/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_3468;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMix
implements IPlayer {
    @Shadow
    @Final
    private class_3442 field_13966;
    @Unique
    long mobControl$lastTick = 0L;

    @Override
    public long mobControl$ticks() {
        return (long)this.field_13966.method_15025(class_3468.field_15419.method_14956((Object)Constants.STAT_PLAYER_DAYS)) * 24000L + (long)this.field_13966.method_15025(class_3468.field_15419.method_14956((Object)Constants.STAT_PLAYER_TICKS));
    }

    @Override
    public void mobControl$setDays(int days) {
        ServerPlayerMix serverPlayerMix = this;
        if (serverPlayerMix instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)serverPlayerMix;
            this.field_13966.method_15022((class_1657)serverPlayer, class_3468.field_15419.method_14956((Object)Constants.STAT_PLAYER_DAYS), days);
            this.field_13966.method_15023((class_1657)serverPlayer, class_3468.field_15419.method_14956((Object)Constants.STAT_PLAYER_TICKS), 0);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        ServerPlayerMix serverPlayerMix = this;
        if (serverPlayerMix instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)serverPlayerMix;
            if ((long)serverPlayer.field_6012 < this.mobControl$lastTick - 1000L) {
                Constants.LOG.debug("Forced tick reset on player: {}", (Object)serverPlayer.field_6012);
                this.mobControl$lastTick = 0L;
            }
            if ((long)serverPlayer.field_6012 > this.mobControl$lastTick) {
                this.mobControl$lastTick = serverPlayer.field_6012;
                this.field_13966.method_15022((class_1657)serverPlayer, class_3468.field_15419.method_14956((Object)Constants.STAT_PLAYER_TICKS), 1);
                if (this.field_13966.method_15025(class_3468.field_15419.method_14956((Object)Constants.STAT_PLAYER_TICKS)) >= 24000) {
                    this.mobControl$setDays(1);
                }
                class_3218 serverLevel = serverPlayer.method_51469();
                for (MobEx mobEx : Config.mobs.values()) {
                    if (mobEx.isWild() || mobEx.entityType() == null) continue;
                    class_2338 pos = serverPlayer.method_24515();
                    long playerDays = this.mobControl$ticks() / 24000L;
                    class_1297 entity = mobEx.entityType().method_5883((class_1937)serverLevel, null);
                    if (!(entity instanceof class_1308)) continue;
                    class_1308 mob = (class_1308)entity;
                    ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(Constants.ReasonControl));
                    ((IMob)mob).mobControl$getMobSpawn().dayCheck = playerDays;
                    entity.method_5808((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), Util.random.nextFloat() * 360.0f, 0.0f);
                    if (mob.method_29504()) continue;
                    serverLevel.method_8649((class_1297)mob);
                }
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void die(class_1282 cause, CallbackInfo ci) {
        class_3222 serverPlayer = (class_3222)this;
        class_2338 pos = serverPlayer.method_24515();
        Constants.LOG.debug("Player {} died by {} @ {} {} {}", new Object[]{serverPlayer.method_5476().getString(), cause.method_48792().comp_1242(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
    }
}

