/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Results;
import com.crackerjackbox.toml.WriterContext;
import com.crackerjackbox.toml.iface.IValueReader;
import com.crackerjackbox.toml.iface.IValueWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateValueReaderWriter
implements IValueReader,
IValueWriter {
    static final DateValueReaderWriter DATE_VALUE_READER_WRITER = new DateValueReaderWriter();
    private static final Pattern DATE_REGEX = Pattern.compile("(\\d{4}-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-5][0-9]:[0-5][0-9])(\\.\\d*)?(Z|(?:[+\\-]\\d{2}:\\d{2}))(.*)");

    @Override
    public boolean canRead(String string) {
        if (string.length() < 5) {
            return false;
        }
        for (int index = 0; index < 5; ++index) {
            char character = string.charAt(index);
            if (!(index < 4 ? !Character.isDigit(character) : character != '-')) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object read(String string, AtomicInteger atomicInteger, Context context) {
        String stringBuilder;
        Matcher matcher;
        StringBuilder sb = new StringBuilder();
        int index = atomicInteger.get();
        while (index < string.length()) {
            char character = string.charAt(index);
            if (!Character.isDigit(character) && character != '-' && character != '+' && character != ':' && character != '.' && character != 'T' && character != 'Z') {
                atomicInteger.decrementAndGet();
                break;
            }
            sb.append(character);
            index = atomicInteger.incrementAndGet();
        }
        if (!(matcher = DATE_REGEX.matcher(stringBuilder = sb.toString())).matches()) {
            Results.Errors errors = new Results.Errors();
            errors.invalidValue(context.identifier.getName(), stringBuilder, context.line.get());
            return errors;
        }
        Object dateString = matcher.group(1);
        String zone = matcher.group(3);
        String fractionalSeconds = matcher.group(2);
        Object format = "yyyy-MM-dd'T'HH:mm:ss";
        if (fractionalSeconds != null && !fractionalSeconds.isEmpty()) {
            format = (String)format + ".SSS";
            dateString = (String)dateString + fractionalSeconds;
        }
        format = (String)format + "Z";
        if ("Z".equals(zone)) {
            dateString = (String)dateString + "+0000";
        } else if (zone.contains(":")) {
            dateString = (String)dateString + zone.replace(":", "");
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat((String)format);
            dateFormat.setLenient(false);
            return dateFormat.parse((String)dateString);
        }
        catch (Exception ex) {
            Results.Errors errors = new Results.Errors();
            errors.invalidValue(context.identifier.getName(), stringBuilder, context.line.get());
            return errors;
        }
    }

    @Override
    public boolean canWrite(Object value) {
        return value instanceof Date;
    }

    @Override
    public void write(Object value, WriterContext context) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        context.write(formatter.format(value));
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }
}

