/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Results;
import com.crackerjackbox.toml.WriterContext;
import com.crackerjackbox.toml.iface.IValueReader;
import com.crackerjackbox.toml.iface.IValueWriter;
import java.util.concurrent.atomic.AtomicInteger;

public class NumberValueReaderWriter
implements IValueReader,
IValueWriter {
    static final NumberValueReaderWriter NUMBER_VALUE_READER_WRITER = new NumberValueReaderWriter();

    @Override
    public boolean canRead(String string) {
        char firstChar = string.charAt(0);
        return firstChar == '+' || firstChar == '-' || Character.isDigit(firstChar);
    }

    @Override
    public Object read(String string, AtomicInteger atomicInteger, Context context) {
        boolean signable = true;
        boolean dottable = false;
        boolean exponentable = false;
        boolean terminatable = false;
        boolean underscorable = false;
        String type = "";
        StringBuilder sb = new StringBuilder();
        int index = atomicInteger.get();
        while (index < string.length()) {
            boolean notLastChar;
            char character = string.charAt(index);
            boolean bl = notLastChar = string.length() > index + 1;
            if (Character.isDigit(character)) {
                sb.append(character);
                signable = false;
                terminatable = true;
                if (type.isEmpty()) {
                    type = "integer";
                    dottable = true;
                }
                underscorable = notLastChar;
                exponentable = !type.equals("exponent");
            } else if ((character == '+' || character == '-') && signable && notLastChar) {
                signable = false;
                terminatable = false;
                if (character == '-') {
                    sb.append('-');
                }
            } else if (character == '.' && dottable && notLastChar) {
                sb.append('.');
                type = "float";
                terminatable = false;
                dottable = false;
                exponentable = false;
                underscorable = false;
            } else if ((character == 'E' || character == 'e') && exponentable && notLastChar) {
                sb.append('E');
                type = "exponent";
                terminatable = false;
                signable = true;
                dottable = false;
                exponentable = false;
                underscorable = false;
            } else if (character == '_' && underscorable && notLastChar && Character.isDigit(string.charAt(index + 1))) {
                underscorable = false;
            } else {
                if (!terminatable) {
                    type = "";
                }
                atomicInteger.decrementAndGet();
                break;
            }
            index = atomicInteger.incrementAndGet();
        }
        switch (type) {
            case "integer": {
                return Long.valueOf(sb.toString());
            }
            case "float": {
                return Double.valueOf(sb.toString());
            }
            case "exponent": {
                String[] exponentString = sb.toString().split("E");
                return Double.parseDouble(exponentString[0]) * Math.pow(10.0, Double.parseDouble(exponentString[1]));
            }
        }
        Results.Errors errors = new Results.Errors();
        errors.invalidValue(context.identifier.getName(), sb.toString(), context.line.get());
        return errors;
    }

    @Override
    public boolean canWrite(Object value) {
        return value instanceof Number;
    }

    @Override
    public void write(Object value, WriterContext context) {
        context.write(value.toString());
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    public String toString() {
        return "number";
    }
}

