/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import java.io.IOException;
import java.io.Writer;

public class WriterContext {
    private String arrayKey = null;
    private boolean isArrayOfTable = false;
    private boolean empty = true;
    private final String key;
    private final Writer output;

    WriterContext(Writer output) {
        this("", output);
    }

    WriterContext pushTable(String newKey) {
        String fullKey = this.key.isEmpty() ? newKey : this.key + "." + newKey;
        WriterContext subContext = new WriterContext(fullKey, this.output);
        if (!this.empty) {
            subContext.empty = false;
        }
        return subContext;
    }

    WriterContext pushTableFromArray() {
        WriterContext subContext = new WriterContext(this.key, this.output);
        if (!this.empty) {
            subContext.empty = false;
        }
        subContext.isArrayOfTable = true;
        return subContext;
    }

    WriterContext write(String string) {
        try {
            this.output.write(string);
            if (this.empty && !string.isEmpty()) {
                this.empty = false;
            }
            return this;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    WriterContext write(char character) {
        try {
            this.output.write(character);
            this.empty = false;
            return this;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    void writeKey() {
        if (this.key.isEmpty()) {
            return;
        }
        if (!this.empty) {
            this.write('\n');
        }
        if (this.isArrayOfTable) {
            this.write("[[").write(this.key).write("]]\n");
        } else {
            this.write('[').write(this.key).write("]\n");
        }
    }

    void setArrayKey(String arrayKey) {
        this.arrayKey = arrayKey;
    }

    String getContextPath() {
        return this.key.isEmpty() ? this.arrayKey : this.key + "." + this.arrayKey;
    }

    private WriterContext(String key, Writer output) {
        this.key = key;
        this.output = output;
    }
}

