/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.data;

import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ServerSavedData
extends SavedData {
    private long ticks;

    protected ServerSavedData(long ticks) {
        this.ticks = ticks;
    }

    public static ServerSavedData init(MinecraftServer server) {
        return (ServerSavedData)Objects.requireNonNull(server.getLevel(ServerLevel.OVERWORLD)).getDataStorage().computeIfAbsent(new SavedData.Factory(ServerSavedData::create, ServerSavedData::load, DataFixTypes.OPTIONS), "mobcontrol");
    }

    public static ServerSavedData load(CompoundTag nbt, HolderLookup.Provider registries) {
        return new ServerSavedData(nbt.getLong("ticks"));
    }

    public static ServerSavedData create() {
        return new ServerSavedData(0L);
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        compoundTag.putLong("ticks", this.ticks);
        return compoundTag;
    }

    public void setTicks(long ticks) {
        if (this.ticks != ticks) {
            this.ticks = ticks;
            this.setDirty();
        }
    }

    public long getTicks() {
        return this.ticks;
    }
}

