/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BaseSpawner.class})
public abstract class BaseSpawnerMix {
    @Shadow
    private int requiredPlayerRange;
    @Unique
    private MobEx mobControl$mobEx;
    @Unique
    private UUID mobControl$lastReloadedId;

    @Shadow
    protected abstract boolean isNearPlayer(Level var1, BlockPos var2);

    @Shadow
    protected abstract SpawnData getOrCreateNextSpawnData(@Nullable Level var1, RandomSource var2, BlockPos var3);

    @Inject(method={"serverTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void serverTick(ServerLevel serverLevel, BlockPos pos, CallbackInfo ci) {
        Mob mob;
        Entity entity;
        if (!this.isNearPlayer((Level)serverLevel, pos)) {
            return;
        }
        long playerDays = -1L;
        for (Player player : serverLevel.players()) {
            if (!EntitySelector.NO_SPECTATORS.test(player) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(player)) continue;
            double distanceToSqr = player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            if (!((float)this.requiredPlayerRange < 0.0f) && !(distanceToSqr < (double)(this.requiredPlayerRange * this.requiredPlayerRange))) continue;
            playerDays = Math.max(((IPlayer)player).mobControl$ticks() / 24000L, playerDays);
        }
        if (playerDays == -1L) {
            return;
        }
        SpawnData spawndata = this.getOrCreateNextSpawnData((Level)serverLevel, serverLevel.getRandom(), pos);
        CompoundTag compoundtag = spawndata.getEntityToSpawn();
        Optional optional = EntityType.by((CompoundTag)compoundtag);
        if (optional.isPresent() && Config.lastReloadedId != null && this.mobControl$lastReloadedId != Config.lastReloadedId) {
            this.mobControl$lastReloadedId = Config.lastReloadedId;
            entity = ((EntityType)optional.get()).create((Level)serverLevel, EntitySpawnReason.SPAWNER);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                this.mobControl$mobEx = Util.getMobEx(mob, EntityType.getKey((EntityType)((EntityType)optional.get())));
            }
        }
        if (this.mobControl$mobEx != null && optional.isPresent() && (entity = ((EntityType)optional.get()).create((Level)serverLevel, EntitySpawnReason.SPAWNER)) instanceof Mob) {
            mob = (Mob)entity;
            ((IMob)mob).mobControl$getMobSpawn().dayCheck = playerDays;
            entity.moveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, Util.random.nextFloat() * 360.0f, 0.0f);
            if (!mob.isDeadOrDying()) {
                serverLevel.addFreshEntity((Entity)mob);
            }
            ci.cancel();
        }
    }
}

