/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Constants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PersistentEntitySectionManager.class})
public abstract class PersistentEntitySectionManagerMix<T extends EntityAccess> {
    @Unique
    public void mobControl$setMobStat(ResourceLocation resourceLocation, int count) {
        if (Constants.MOB_STATS.containsKey(resourceLocation.toString())) {
            Constants.MOB_STATS.put(resourceLocation.toString(), Constants.MOB_STATS.get(resourceLocation.toString()) + (long)count);
        } else {
            Constants.MOB_STATS.put(resourceLocation.toString(), Long.valueOf(count));
        }
    }

    @Inject(method={"startTracking"}, at={@At(value="HEAD")})
    private void startTracking(T entity, CallbackInfo ci) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            this.mobControl$setMobStat(EntityType.getKey((EntityType)mob.getType()), 1);
        }
    }

    @Inject(method={"stopTracking"}, at={@At(value="HEAD")})
    private void stopTracking(T entity, CallbackInfo ci) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            this.mobControl$setMobStat(EntityType.getKey((EntityType)mob.getType()), -1);
        }
    }
}

