/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMix {
    @Shadow
    private Level level;

    @Shadow
    public abstract EntityType<?> getType();

    @Shadow
    public abstract boolean isAlive();

    @Shadow
    public abstract void gameEvent(Holder<GameEvent> var1, @Nullable Entity var2);

    @Inject(method={"moveTo(DDDFF)V"}, at={@At(value="RETURN")})
    private void moveTo(double x, double y, double z, float yRot, float xRot, CallbackInfo ci) {
        if (Util.isGenerating) {
            return;
        }
        EntityMix entityMix = this;
        if (entityMix instanceof Mob) {
            Mob mob = (Mob)entityMix;
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (((IMob)mob).mobControl$getRule() == null && !Util.setMob(serverLevel, mob, x, y, z)) {
                    mob.discard();
                    mob.setHealth(0.0f);
                }
            }
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void interact(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        EntityMix entityMix = this;
        if (entityMix instanceof Mob) {
            Mob mob = (Mob)entityMix;
            ItemStack itemStack = player.getItemInHand(hand);
            if (this.level.isClientSide() && itemStack.is(Items.LEAD)) {
                cir.setReturnValue((Object)InteractionResult.SUCCESS);
                return;
            }
            MobExRule mobExRule = ((IMob)mob).mobControl$getRule();
            if (mobExRule != null && mobExRule.set.canLead != null) {
                EntityMix entityMix2;
                if (this.isAlive() && (entityMix2 = this) instanceof Leashable) {
                    Leashable leashable = (Leashable)entityMix2;
                    if (leashable.getLeashHolder() == player) {
                        if (player.hasInfiniteMaterials()) {
                            leashable.removeLeash();
                        } else {
                            leashable.dropLeash();
                        }
                        this.gameEvent((Holder<GameEvent>)GameEvent.ENTITY_INTERACT, (Entity)player);
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                        return;
                    }
                    if (itemStack.is(Items.LEAD) && MobEx.can(mobExRule.set.canLead)) {
                        leashable.setLeashedTo((Entity)player, true);
                        itemStack.shrink(1);
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                        return;
                    }
                }
                cir.setReturnValue((Object)InteractionResult.PASS);
            }
        }
    }
}

