/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.data.ServerSavedData;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.iface.IServerLevel;
import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMix
implements IServerLevel {
    @Shadow
    @Final
    private ServerLevelData serverLevelData;
    @Unique
    private ServerSavedData mobControl$savedData = null;
    @Unique
    long mobControl$lastTick = 0L;

    @Shadow
    public abstract MinecraftServer getServer();

    @Shadow
    public abstract ServerLevel getLevel();

    @Override
    public ServerSavedData mobControl$savedData() {
        return this.mobControl$savedData;
    }

    @Inject(method={"addEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void addEntity(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity.isRemoved()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        ServerLevel serverLevel;
        if (this.mobControl$savedData == null) {
            this.mobControl$savedData = ServerSavedData.init(this.getServer());
        }
        if ((serverLevel = (ServerLevel)this).dimension().equals((Object)ServerLevel.OVERWORLD) && this.serverLevelData.getGameTime() > this.mobControl$lastTick) {
            this.mobControl$lastTick = this.serverLevelData.getGameTime();
            this.mobControl$savedData.setTicks(this.mobControl$savedData.getTicks() + 1L);
        }
    }

    @Inject(method={"wakeUpAllPlayers"}, at={@At(value="HEAD")})
    private void wakeUpAllPlayers(CallbackInfo ci) {
        for (ServerPlayer serverPlayer : this.getServer().getPlayerList().getPlayers()) {
            ((IPlayer)serverPlayer).mobControl$setNextDay();
        }
        float days = (float)this.mobControl$savedData.getTicks() / 24000.0f;
        this.mobControl$savedData.setTicks(((long)(days - days % 1.0f) + 1L) * 24000L);
    }
}

