/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMix
implements IPlayer {
    @Shadow
    @Final
    private ServerStatsCounter stats;
    @Unique
    long mobControl$lastTick = 0L;

    @Override
    public long mobControl$ticks() {
        return (long)this.stats.getValue(Stats.CUSTOM.get((Object)Constants.STAT_PLAYER_DAYS)) * 24000L + (long)this.stats.getValue(Stats.CUSTOM.get((Object)Constants.STAT_PLAYER_TICKS));
    }

    @Override
    public void mobControl$setDays(int days) {
        ServerPlayerMix serverPlayerMix = this;
        if (serverPlayerMix instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerMix;
            this.stats.increment((Player)serverPlayer, Stats.CUSTOM.get((Object)Constants.STAT_PLAYER_DAYS), days);
            this.stats.setValue((Player)serverPlayer, Stats.CUSTOM.get((Object)Constants.STAT_PLAYER_TICKS), 0);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        ServerPlayerMix serverPlayerMix = this;
        if (serverPlayerMix instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerMix;
            if ((long)serverPlayer.tickCount < this.mobControl$lastTick - 1000L) {
                Constants.LOG.debug("Forced tick reset on player: {}", (Object)serverPlayer.tickCount);
                this.mobControl$lastTick = 0L;
            }
            if ((long)serverPlayer.tickCount > this.mobControl$lastTick) {
                this.mobControl$lastTick = serverPlayer.tickCount;
                this.stats.increment((Player)serverPlayer, Stats.CUSTOM.get((Object)Constants.STAT_PLAYER_TICKS), 1);
                if (this.stats.getValue(Stats.CUSTOM.get((Object)Constants.STAT_PLAYER_TICKS)) >= 24000) {
                    this.mobControl$setDays(1);
                }
                ServerLevel serverLevel = serverPlayer.serverLevel();
                for (MobEx mobEx : Config.mobs.values()) {
                    if (mobEx.isWild() || mobEx.entityType() == null) continue;
                    BlockPos pos = serverPlayer.blockPosition();
                    long playerDays = this.mobControl$ticks() / 24000L;
                    Entity entity = mobEx.entityType().create((Level)serverLevel);
                    if (!(entity instanceof Mob)) continue;
                    Mob mob = (Mob)entity;
                    ((IMob)entity).mobControl$setMobSpawn(new MobSpawn(Constants.ReasonControl));
                    ((IMob)mob).mobControl$getMobSpawn().dayCheck = playerDays;
                    entity.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), Util.random.nextFloat() * 360.0f, 0.0f);
                    if (mob.isDeadOrDying()) continue;
                    serverLevel.addFreshEntity((Entity)mob);
                }
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void die(DamageSource cause, CallbackInfo ci) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        BlockPos pos = serverPlayer.blockPosition();
        Constants.LOG.debug("Player {} died by {} @ {} {} {}", new Object[]{serverPlayer.getDisplayName().getString(), cause.type().msgId(), pos.getX(), pos.getY(), pos.getZ()});
    }
}

