/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.ai;

import com.crackerjackbox.mobcontrol.iface.IBat;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GenericHurtByTargetGoal
extends TargetGoal {
    private final Mob mob;
    private boolean alertSameType;
    private int timestamp;

    public GenericHurtByTargetGoal(Mob mob) {
        super(mob, true);
        this.mob = mob;
    }

    public boolean canUse() {
        int lastHurtByTimestamp = this.mob.getLastHurtByMobTimestamp();
        LivingEntity livingEntity = this.mob.getLastHurtByMob();
        if (lastHurtByTimestamp != this.timestamp && livingEntity != null) {
            Mob mob = this.mob;
            if (mob instanceof IBat) {
                IBat bat = (IBat)mob;
                bat.mobControl$setTagetPosition(livingEntity.blockPosition());
            }
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        LivingEntity livingEntity = this.mob.getTarget();
        return livingEntity != null && this.mob.canAttack(livingEntity);
    }

    public GenericHurtByTargetGoal setAlertOthers() {
        this.alertSameType = true;
        return this;
    }

    public void start() {
        this.mob.setTarget(this.mob.getLastHurtByMob());
        this.targetMob = this.mob.getTarget();
        this.timestamp = this.mob.getLastHurtByMobTimestamp();
        this.unseenMemoryTicks = 600;
        if (this.alertSameType) {
            this.alertOthers();
        }
        super.start();
    }

    protected void alertOthers() {
        LivingEntity lastHurtByMob = this.mob.getLastHurtByMob();
        if (lastHurtByMob == null) {
            return;
        }
        double followDistance = this.getFollowDistance();
        AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)this.mob.position()).inflate(followDistance, 10.0, followDistance);
        List list = this.mob.level().getEntitiesOfClass(this.mob.getClass(), aabb, EntitySelector.NO_SPECTATORS);
        for (Mob otherMob : list) {
            if (this.mob == otherMob || otherMob.getTarget() != null || otherMob.isAlliedTo((Entity)lastHurtByMob)) continue;
            otherMob.setTarget(lastHurtByMob);
            otherMob.setLastHurtByMob(lastHurtByMob);
            if (!(otherMob instanceof IBat)) continue;
            IBat bat = (IBat)otherMob;
            bat.mobControl$setTagetPosition(lastHurtByMob.blockPosition());
        }
    }
}

