/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ServerSavedData
extends SavedData {
    private long ticks;
    public static Codec<ServerSavedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("ticks").forGetter(cache -> cache.ticks)).apply((Applicative)builder, ServerSavedData::new));

    public ServerSavedData() {
        this.ticks = 0L;
    }

    public ServerSavedData(long ticks) {
        this.ticks = ticks;
    }

    public static ServerSavedData init(MinecraftServer server) {
        DimensionDataStorage storage = Objects.requireNonNull(server.getLevel(ServerLevel.OVERWORLD)).getDataStorage();
        return (ServerSavedData)storage.computeIfAbsent(new SavedDataType("mobcontrol", ServerSavedData::new, CODEC, null));
    }

    public void setTicks(long ticks) {
        if (this.ticks != ticks) {
            this.ticks = ticks;
            this.setDirty();
        }
    }

    public long getTicks() {
        return this.ticks;
    }
}

