/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.iface.IMob;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EndDragonFight.class})
public abstract class EndDragonFightMix {
    @Shadow
    @Final
    private ServerBossEvent dragonEvent;
    @Shadow
    private boolean previouslyKilled;
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private BlockPos origin;
    @Shadow
    private boolean dragonKilled;

    @Shadow
    protected abstract void spawnExitPortal(boolean var1);

    @Shadow
    protected abstract void spawnNewGateway();

    @Inject(method={"setDragonKilled"}, at={@At(value="HEAD")})
    protected void setDragonKilled(EnderDragon dragon, CallbackInfo ci) {
        IMob iMob;
        if (dragon == null || dragon instanceof IMob && (iMob = (IMob)dragon).mobControl$getCancelBossFight()) {
            this.dragonEvent.setProgress(0.0f);
            this.dragonEvent.setVisible(false);
            this.spawnExitPortal(true);
            this.spawnNewGateway();
            if (!this.previouslyKilled) {
                this.level.setBlockAndUpdate(this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.getLocation((BlockPos)this.origin)), Blocks.DRAGON_EGG.defaultBlockState());
            }
            this.previouslyKilled = true;
            this.dragonKilled = true;
        }
    }
}

