/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityType.class})
public abstract class EntityTypeMix {
    @Inject(method={"create(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/EntitySpawnReason;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")})
    private void create(Level level, EntitySpawnReason spawnReason, CallbackInfoReturnable<Entity> cir) {
        Entity entity = (Entity)cir.getReturnValue();
        if (!level.isClientSide && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (spawnReason != null) {
                ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(spawnReason.toString()));
            }
        }
    }

    @Inject(method={"create(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/EntitySpawnReason;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void create(CompoundTag tag, Level level, EntitySpawnReason spawnReason, CallbackInfoReturnable<Optional<Entity>> cir) {
        cir.setReturnValue((Object)Util.ifElse(EntityType.by((CompoundTag)tag).map(entityType -> entityType.create(level, spawnReason)), entity -> entity.load(tag), () -> Constants.LOG.debug("Skipping Entity with id {}", (Object)tag.getStringOr("id", "[invalid]"))));
    }
}

