/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.ArrayValueWriter;
import com.crackerjackbox.toml.ValueWriters;
import com.crackerjackbox.toml.WriterContext;
import com.crackerjackbox.toml.iface.IValueWriter;
import java.util.Collection;

public class PrimitiveArrayValueWriter
extends ArrayValueWriter {
    static final IValueWriter PRIMITIVE_ARRAY_VALUE_WRITER = new PrimitiveArrayValueWriter();

    @Override
    public boolean canWrite(Object value) {
        return PrimitiveArrayValueWriter.isCollectionOrArray(value) && PrimitiveArrayValueWriter.isArrayOfPrimitive(value);
    }

    @Override
    public void write(Object o, WriterContext context) {
        Collection<?> values = this.normalize(o);
        context.write('[');
        boolean first = true;
        IValueWriter firstWriter = null;
        for (Object value : values) {
            if (first) {
                firstWriter = ValueWriters.WRITERS.findWriterFor(value);
                first = false;
            } else {
                IValueWriter writer = ValueWriters.WRITERS.findWriterFor(value);
                if (writer != firstWriter) {
                    throw new IllegalStateException(context.getContextPath() + ": cannot write a un-assignable array; first element was of type " + String.valueOf(firstWriter) + " but found " + String.valueOf(writer));
                }
                context.write(", ");
            }
            ValueWriters.WRITERS.findWriterFor(value).write(value, context);
        }
        context.write(']');
    }

    public String toString() {
        return "primitive-array";
    }
}

