/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Identifier;
import com.crackerjackbox.toml.Results;
import com.crackerjackbox.toml.ValueReaders;
import com.crackerjackbox.toml.iface.IValueReader;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class InlineTableValueReader
implements IValueReader {
    static final InlineTableValueReader INLINE_TABLE_VALUE_READER = new InlineTableValueReader();

    @Override
    public boolean canRead(String string) {
        return string.startsWith("{");
    }

    @Override
    public Object read(String string, AtomicInteger atomicInteger, Context context) {
        AtomicInteger line = context.line;
        int startLine = line.get();
        int startIndex = atomicInteger.get();
        boolean inKey = true;
        boolean inValue = false;
        boolean terminated = false;
        StringBuilder currentKey = new StringBuilder();
        HashMap<String, Object> results = new HashMap<String, Object>();
        Results.Errors errors = new Results.Errors();
        int index = atomicInteger.incrementAndGet();
        while (atomicInteger.get() < string.length()) {
            char character = string.charAt(index);
            if (inValue && !Character.isWhitespace(character)) {
                Object converted = ValueReaders.VALUE_READERS.convert(string, atomicInteger, context.with(Identifier.from(currentKey.toString(), context)));
                if (converted instanceof Results.Errors) {
                    errors.add((Results.Errors)converted);
                    return errors;
                }
                String currentKeyTrimmed = currentKey.toString().trim();
                Object previous = results.put(currentKeyTrimmed, converted);
                if (previous != null) {
                    errors.duplicateKey(currentKeyTrimmed, context.line.get());
                    return errors;
                }
                currentKey = new StringBuilder();
                inValue = false;
            } else if (character == ',') {
                inKey = true;
                inValue = false;
                currentKey = new StringBuilder();
            } else if (character == '=') {
                inKey = false;
                inValue = true;
            } else {
                if (character == '}') {
                    terminated = true;
                    break;
                }
                if (inKey) {
                    currentKey.append(character);
                }
            }
            index = atomicInteger.incrementAndGet();
        }
        if (!terminated) {
            errors.unterminated(context.identifier.getName(), string.substring(startIndex), startLine);
        }
        return errors.hasErrors() ? errors : results;
    }
}

