/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.toml.Container;
import com.crackerjackbox.toml.Identifier;
import com.crackerjackbox.toml.Keys;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class Results {
    final Errors errors = new Errors();
    private final Deque<Container> stack = new ArrayDeque<Container>();

    Results() {
        this.stack.push(new Container.Table(""));
    }

    void addValue(String key, Object value, AtomicInteger line) {
        Container currentTable = this.stack.peek();
        assert (currentTable != null);
        if (value instanceof Map) {
            String path = this.getInlineTablePath(key);
            if (path == null) {
                this.startTable(key, line);
            } else {
                this.startTables(Identifier.from(path.isEmpty() ? key : path, null), line);
            }
            Set entrySet = ((Map)value).entrySet();
            for (Map.Entry entry : entrySet) {
                this.addValue(entry.getKey().toString(), entry.getValue(), line);
            }
            this.stack.pop();
        } else if (currentTable.accepts(key)) {
            currentTable.put(key, value);
        } else if (currentTable.get(key) instanceof Container) {
            this.errors.keyDuplicatesTable(key, line);
        } else {
            this.errors.duplicateKey(key, line != null ? line.get() : -1);
        }
    }

    void startTableArray(Identifier identifier, AtomicInteger line) {
        String tableName = identifier.getBareName();
        while (this.stack.size() > 1) {
            this.stack.pop();
        }
        Keys.Key[] tableParts = Keys.split(tableName);
        for (int index = 0; index < tableParts.length; ++index) {
            String tablePart = tableParts[index].name;
            Container currentContainer = this.stack.peek();
            if (currentContainer == null) {
                Constants.LOG.warn("startTableArray currentContainer == null");
                break;
            }
            Object object = currentContainer.get(tablePart);
            if (object instanceof Container.TableArray) {
                Container.TableArray currentTableArray = (Container.TableArray)object;
                this.stack.push(currentTableArray);
                if (index == tableParts.length - 1) {
                    currentTableArray.put(tablePart, new Container.Table());
                }
                this.stack.push(currentTableArray.getCurrent());
                continue;
            }
            object = currentContainer.get(tablePart);
            if (object instanceof Container.Table) {
                Container.Table nextTable = (Container.Table)object;
                if (index < tableParts.length - 1) {
                    this.stack.push(nextTable);
                    continue;
                }
            }
            if (currentContainer.accepts(tablePart)) {
                Container newContainer = index == tableParts.length - 1 ? new Container.TableArray() : new Container.Table();
                this.addValue(tablePart, newContainer, line);
                this.stack.push(newContainer);
                if (!(newContainer instanceof Container.TableArray)) continue;
                this.stack.push(((Container.TableArray)newContainer).getCurrent());
                continue;
            }
            this.errors.duplicateTable(tableName, line.get());
            break;
        }
    }

    void startTables(Identifier id, AtomicInteger line) {
        String tableName = id.getBareName();
        while (this.stack.size() > 1) {
            this.stack.pop();
        }
        Keys.Key[] tableParts = Keys.split(tableName);
        for (int index = 0; index < tableParts.length; ++index) {
            String tablePart = tableParts[index].name;
            Container currentContainer = this.stack.peek();
            if (currentContainer == null) {
                Constants.LOG.warn("startTables currentContainer == null");
                break;
            }
            Object object = currentContainer.get(tablePart);
            if (object instanceof Container) {
                Container nextTable = (Container)object;
                if (index == tableParts.length - 1 && !nextTable.isImplicit()) {
                    this.errors.duplicateTable(tableName, line.get());
                    return;
                }
                this.stack.push(nextTable);
                if (!(this.stack.peek() instanceof Container.TableArray)) continue;
                this.stack.push(((Container.TableArray)this.stack.peek()).getCurrent());
                continue;
            }
            if (currentContainer.accepts(tablePart)) {
                this.startTable(tablePart, index < tableParts.length - 1, line);
                continue;
            }
            this.errors.tableDuplicatesKey(tablePart, line);
            break;
        }
    }

    Map<String, Object> consume() {
        Container values = this.stack.getLast();
        this.stack.clear();
        return ((Container.Table)values).consume();
    }

    private void startTable(String tableName, AtomicInteger line) {
        Container.Table newTable = new Container.Table(tableName);
        this.addValue(tableName, newTable, line);
        this.stack.push(newTable);
    }

    private void startTable(String tableName, boolean implicit, AtomicInteger line) {
        Container.Table newTable = new Container.Table(tableName, implicit);
        this.addValue(tableName, newTable, line);
        this.stack.push(newTable);
    }

    private String getInlineTablePath(String key) {
        Iterator<Container> descendingIterator = this.stack.descendingIterator();
        StringBuilder string = new StringBuilder();
        while (descendingIterator.hasNext()) {
            Container next = descendingIterator.next();
            if (next instanceof Container.TableArray) {
                return null;
            }
            Container.Table table = (Container.Table)next;
            if (table.name == null) break;
            if (!string.isEmpty()) {
                string.append(".");
            }
            string.append(table.name);
        }
        return String.valueOf(string) + (string.isEmpty() ? "" : ".") + "[" + key + "]";
    }

    public static class Errors {
        private final StringBuilder stringBuilder = new StringBuilder();

        void duplicateTable(String table, int line) {
            this.stringBuilder.append("Duplicate table definition on line ").append(line).append(": [").append(table).append("]");
        }

        public void tableDuplicatesKey(String table, AtomicInteger line) {
            this.stringBuilder.append("Key already exists for table defined on line ").append(line.get()).append(": [").append(table).append("]");
        }

        public void keyDuplicatesTable(String key, AtomicInteger line) {
            this.stringBuilder.append("Table already exists for key defined on line ").append(line.get()).append(": ").append(key);
        }

        void emptyImplicitTable(String table, int line) {
            this.stringBuilder.append("Invalid table definition due to empty implicit table name: ").append(table);
        }

        void invalidTable(String table, int line) {
            this.stringBuilder.append("Invalid table definition on line ").append(line).append(": ").append(table).append("]");
        }

        void duplicateKey(String key, int line) {
            this.stringBuilder.append("Duplicate key");
            if (line > -1) {
                this.stringBuilder.append(" on line ").append(line);
            }
            this.stringBuilder.append(": ").append(key);
        }

        void invalidTextAfterIdentifier(Identifier identifier, char text, int line) {
            this.stringBuilder.append("Invalid text after key ").append(identifier.getName()).append(" on line ").append(line).append(". Make sure to terminate the value or add a comment (#).");
        }

        void invalidKey(String key, int line) {
            this.stringBuilder.append("Invalid key on line ").append(line).append(": ").append(key);
        }

        void invalidTableArray(String tableArray, int line) {
            this.stringBuilder.append("Invalid table array definition on line ").append(line).append(": ").append(tableArray);
        }

        void invalidValue(String key, String value, int line) {
            this.stringBuilder.append("Invalid value on line ").append(line).append(": ").append(key).append("=").append(value);
        }

        void unterminatedKey(String key, int line) {
            this.stringBuilder.append("Key is not followed by an equals sign on line ").append(line).append(": ").append(key);
        }

        void unterminated(String key, String value, int line) {
            this.stringBuilder.append("Unterminated value on line ").append(line).append(": ").append(key).append("=").append(value.trim());
        }

        public void notAssignable(String key, int line) {
            this.stringBuilder.append(key).append(" becomes a heterogeneous array on line ").append(line);
        }

        boolean hasErrors() {
            return !this.stringBuilder.isEmpty();
        }

        public String toString() {
            return this.stringBuilder.toString();
        }

        public void add(Errors other) {
            this.stringBuilder.append((CharSequence)other.stringBuilder);
        }
    }
}

