/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Identifier;
import java.util.concurrent.atomic.AtomicInteger;

public class IdentifierConverter {
    static final IdentifierConverter IDENTIFIER_CONVERTER = new IdentifierConverter();

    Identifier convert(String string, AtomicInteger atomicInteger, Context context) {
        boolean quoted = false;
        StringBuilder name = new StringBuilder();
        boolean terminated = false;
        boolean isKey = string.charAt(atomicInteger.get()) != '[';
        boolean isTableArray = !isKey && string.length() > atomicInteger.get() + 1 && string.charAt(atomicInteger.get() + 1) == '[';
        boolean inComment = false;
        int index = atomicInteger.get();
        while (index < string.length()) {
            char character = string.charAt(index);
            if (!(character != '\"' && character != '\'' || index != 0 && string.charAt(index - 1) == '\\')) {
                quoted = !quoted;
                name.append(character);
            } else {
                if (character == '\n') {
                    atomicInteger.decrementAndGet();
                    break;
                }
                if (quoted) {
                    name.append(character);
                } else {
                    if (character == '=' && isKey) {
                        terminated = true;
                        break;
                    }
                    if (character == ']' && !isKey) {
                        if (!isTableArray || string.length() > atomicInteger.get() + 1 && string.charAt(atomicInteger.get() + 1) == ']') {
                            terminated = true;
                            name.append(']');
                            if (isTableArray) {
                                name.append(']');
                            }
                        }
                    } else if (terminated && character == '#') {
                        inComment = true;
                    } else {
                        if (terminated && !Character.isWhitespace(character) && !inComment) {
                            terminated = false;
                            break;
                        }
                        if (!terminated) {
                            name.append(character);
                        }
                    }
                }
            }
            index = atomicInteger.incrementAndGet();
        }
        if (!terminated) {
            if (isKey) {
                context.errors.unterminatedKey(name.toString(), context.line.get());
            } else {
                context.errors.invalidKey(name.toString(), context.line.get());
            }
            return Identifier.INVALID;
        }
        return Identifier.from(name.toString(), context);
    }
}

