/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.command;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.iface.IServerLevel;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class GenericCommand {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_RULES = (ctx, builder) -> {
        for (MobEx mobEx : Config.mobs.values()) {
            for (MobExRule mobExRule : mobEx.rules) {
                if (mobExRule.name == null || mobExRule.name.isEmpty() || mobExRule.name.startsWith("___INTERNAL___")) continue;
                builder.suggest(mobExRule.name);
            }
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext context) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mobcontrol").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(source -> source.hasPermission(4))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.hasPermission(4))).executes(source -> {
            GenericCommand.reload((CommandContext<CommandSourceStack>)source);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(source -> source.hasPermission(4))).executes(source -> {
            Config.logDebug = !Config.logDebug;
            Config.setLoggerLevel();
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7aDebug toggled to: " + (Config.logDebug ? "true" : "false"))), !((CommandSourceStack)source.getSource()).isPlayer());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear-mobs").requires(source -> source.hasPermission(4))).executes(source -> {
            ServerPlayer patt0$temp;
            ServerLevel serverLevel = ((CommandSourceStack)source.getSource()).getLevel();
            ArrayList<Entity> entities = new ArrayList<Entity>();
            serverLevel.getAllEntities().forEach(entity -> {
                if (entity instanceof Mob) {
                    entities.add((Entity)entity);
                }
            });
            entities.forEach(Entity::discard);
            Util.nextTicks.clear();
            if (((CommandSourceStack)source.getSource()).isPlayer() && (patt0$temp = ((CommandSourceStack)source.getSource()).getPlayer()) instanceof ServerPlayer) {
                ServerPlayer sourcePlayer = patt0$temp;
                serverLevel.playSound(null, sourcePlayer.blockPosition(), SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"stats").requires(source -> source.hasPermission(4))).executes(source -> {
            Object patt0$temp;
            if (((CommandSourceStack)source.getSource()).isPlayer() && (patt0$temp = ((CommandSourceStack)source.getSource()).getPlayer()) instanceof ServerPlayer) {
                ServerPlayer sourcePlayer = patt0$temp;
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7aNext Ticks"));
                for (Map.Entry entry : Util.nextTicks.entrySet()) {
                    ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7b" + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()))));
                }
                ServerLevel serverLevel = ((CommandSourceStack)source.getSource()).getLevel();
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7aMobs"));
                for (Map.Entry<String, Long> entry : Constants.MOB_STATS.entrySet()) {
                    ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7b" + entry.getKey() + ": " + String.valueOf(entry.getValue()))));
                }
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7aServer Info"));
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7bDimension: " + serverLevel.dimension().location().getNamespace() + ":" + serverLevel.dimension().location().getPath())));
                if (serverLevel.getBiomeManager().getBiome(sourcePlayer.blockPosition()).unwrapKey().isPresent()) {
                    ResourceLocation resourceLocation2 = ((ResourceKey)serverLevel.getBiomeManager().getBiome(sourcePlayer.blockPosition()).unwrapKey().get()).location();
                    ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7bBiome: " + resourceLocation2.getNamespace() + ":" + resourceLocation2.getPath())));
                }
                ArrayList<ResourceLocation> arrayList = Util.getBiomeTags(serverLevel, sourcePlayer.blockPosition());
                ArrayList arrayList2 = new ArrayList();
                arrayList.forEach(resourceLocation -> biomeTags.add(resourceLocation.getNamespace() + ":" + resourceLocation.getPath()));
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7bBiome Tags: " + (arrayList2.isEmpty() ? "(none)" : String.join((CharSequence)",", arrayList2)))));
                long serverTicks = ((IServerLevel)serverLevel).mobControl$savedData().getTicks();
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7bDays: " + serverTicks + " (" + serverTicks / 24000L + " days)")));
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7bTime of Day: " + serverLevel.getLevelData().getDayTime() % 24000L)));
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7bSky Light: " + serverLevel.getBrightness(LightLayer.SKY, sourcePlayer.blockPosition()) + " @ " + sourcePlayer.blockPosition().getX() + " " + sourcePlayer.blockPosition().getY() + " " + sourcePlayer.blockPosition().getZ())));
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7bBlock Light: " + serverLevel.getBrightness(LightLayer.BLOCK, sourcePlayer.blockPosition()) + " @ " + sourcePlayer.blockPosition().getX() + " " + sourcePlayer.blockPosition().getY() + " " + sourcePlayer.blockPosition().getZ())));
                ArrayList<ResourceLocation> arrayList3 = Util.getStructures(serverLevel, sourcePlayer.blockPosition());
                ArrayList structures = new ArrayList();
                arrayList3.forEach(resourceLocation -> structures.add(resourceLocation.getNamespace() + ":" + resourceLocation.getPath()));
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7bStructures: " + (structures.isEmpty() ? "(none)" : String.join((CharSequence)",", structures)))));
                ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7aPlayer Days"));
                for (ServerPlayer serverPlayer : serverLevel.getServer().getPlayerList().getPlayers()) {
                    long playerTicks = ((IPlayer)serverPlayer).mobControl$ticks();
                    ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)("\u00a7b" + serverPlayer.getDisplayName().getString() + ": " + playerTicks + " (" + playerTicks / 24000L + " days)")));
                }
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"force-summon").requires(source -> source.hasPermission(4))).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(source -> {
            CompoundTag entityCompoundTag = new CompoundTag();
            entityCompoundTag.putString("id", ResourceArgument.getSummonableEntityType((CommandContext)source, (String)"entity").key().location().toString());
            GenericCommand.forceSummon((CommandContext<CommandSourceStack>)source, entityCompoundTag, "");
            return 1;
        })).then(Commands.argument((String)"rule", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_RULES).executes(source -> {
            CompoundTag entityCompoundTag = new CompoundTag();
            entityCompoundTag.putString("id", ResourceArgument.getSummonableEntityType((CommandContext)source, (String)"entity").key().location().toString());
            GenericCommand.forceSummon((CommandContext<CommandSourceStack>)source, entityCompoundTag, StringArgumentType.getString((CommandContext)source, (String)"rule"));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"days").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"days", (ArgumentType)IntegerArgumentType.integer()).executes(source -> {
            ServerPlayer targetPlayer = EntityArgument.getPlayer((CommandContext)source, (String)"target");
            ((IPlayer)targetPlayer).mobControl$setDays(IntegerArgumentType.getInteger((CommandContext)source, (String)"days"));
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal((String)"show-config").requires(source -> source.hasPermission(4))).executes(source -> {
            Path configPath = FileSystems.getDefault().getPath("config", "mobcontrol.toml");
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.literal((String)("\u00a72Click to copy path to clipboard: \u00a76" + String.valueOf(configPath.toAbsolutePath()))).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, configPath.toAbsolutePath().toString()))), !((CommandSourceStack)source.getSource()).isPlayer());
            return 1;
        })))).requires(source -> source.hasPermission(0))).then(Commands.literal((String)"ver").executes(source -> {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.literal((String)"\u00a72Mob Control, version 1.5.13 by \u00a79Ohayden"), !((CommandSourceStack)source.getSource()).isPlayer());
            return 1;
        })));
    }

    private static void forceSummon(CommandContext<CommandSourceStack> source, CompoundTag entityCompoundTag, String ruleName) {
        EntityType.loadEntityRecursive((CompoundTag)entityCompoundTag, (Level)((CommandSourceStack)source.getSource()).getLevel(), (EntitySpawnReason)EntitySpawnReason.COMMAND, entity -> {
            if (entity instanceof Mob) {
                MobExRule mobExRule;
                Mob mob = (Mob)entity;
                ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(Constants.ReasonOverride));
                if (!ruleName.isEmpty() && (mobExRule = Config.findRuleByName(ruleName)) != null) {
                    ((IMob)mob).mobControl$setRule(mobExRule);
                }
            }
            entity.moveTo(((CommandSourceStack)source.getSource()).getPosition());
            ((CommandSourceStack)source.getSource()).getLevel().tryAddFreshEntityWithPassengers(entity);
            return entity;
        });
        ((CommandSourceStack)source.getSource()).sendSystemMessage((Component)Component.literal((String)"\u00a7bOk"));
    }

    private static void reload(CommandContext<CommandSourceStack> source) {
        if (Config.load()) {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7aReload finished"), !((CommandSourceStack)source.getSource()).isPlayer());
        } else {
            ((CommandSourceStack)source.getSource()).sendSuccess(() -> Component.literal((String)"\u00a74Error reloading, check logs and validate config"), !((CommandSourceStack)source.getSource()).isPlayer());
        }
    }
}

