/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.FrogAttackablesSensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FrogAttackablesSensor.class})
public abstract class FrogAttackablesSensorMix {
    @Shadow
    protected abstract boolean isUnreachableAttackTarget(LivingEntity var1, LivingEntity var2);

    @Inject(method={"isMatchingEntity"}, at={@At(value="HEAD")}, cancellable=true)
    protected void isMatchingEntity(ServerLevel serverLevel, LivingEntity attacker, LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        if (attacker instanceof IMob) {
            IMob iMob = (IMob)attacker;
            MobExRule mobExRule = iMob.mobControl$getRule();
            if (mobExRule.set.onHurt != null || mobExRule.set.attack != null) {
                boolean canAttack;
                boolean bl = canAttack = !attacker.getBrain().hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN) && Sensor.isEntityAttackable((ServerLevel)serverLevel, (LivingEntity)attacker, (LivingEntity)target) && !this.isUnreachableAttackTarget(attacker, target) && target.closerThan((Entity)attacker, 10.0);
                if (mobExRule.set.onHurt != null && attacker.getLastHurtByMob() != null && attacker.getLastHurtByMob().getUUID() == target.getUUID()) {
                    cir.setReturnValue((Object)true);
                } else {
                    if (canAttack && mobExRule.set.attack != null) {
                        canAttack = mobExRule.set.attack.contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()).toString());
                    }
                    cir.setReturnValue((Object)canAttack);
                }
            }
        }
    }
}

