/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol;

import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.Range;
import com.crackerjackbox.mobcontrol.data.Weighted;
import com.crackerjackbox.mobcontrol.data.WeightedItem;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.crackerjackbox.toml.Toml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;

public class Config {
    public static HashMap<String, MobEx> mobs = new HashMap();
    public static boolean logDebug = false;
    public static boolean useGenerationCheck = false;
    public static UUID lastReloadedId = null;
    static int ruleCounter = 0;

    public static void load() {
        Toml general;
        Toml toml = null;
        Path configPath = FileSystems.getDefault().getPath("config", "mobcontrol.toml");
        if (new File(configPath.toString()).exists()) {
            toml = new Toml(configPath.toString());
        } else {
            InputStream inputStream = Config.class.getResourceAsStream("/assets/mobcontrol/default/config.toml");
            if (inputStream != null) {
                try {
                    Constants.LOG.info("Missing config: Providing an example to use");
                    Files.copy(inputStream, configPath, StandardCopyOption.REPLACE_EXISTING);
                    toml = new Toml(configPath.toString());
                }
                catch (IOException ex) {
                    Constants.LOG.error("Config::load - Error reading default.toml", (Throwable)ex);
                }
            }
        }
        mobs.clear();
        Toml toml2 = general = toml != null ? toml.getTable("general") : null;
        if (general != null) {
            logDebug = false;
            Config.getTomlInteger(general, "debug", value -> {
                logDebug = value != 0;
            });
            useGenerationCheck = false;
            Config.getTomlInteger(general, "use-generation-check", value -> {
                useGenerationCheck = value != 0;
            });
        } else {
            Constants.LOG.warn("WARNING: Missing [general] section - Using defaults");
            logDebug = false;
        }
        Config.setLoggerLevel();
        if (toml != null) {
            List<Toml> mobArray = toml.getTables("mob");
            if (mobArray == null) {
                throw new Error("Unable to parse mobcontrol.toml. Please use an TOML verifier to ensure correct syntax. (ex: toml-lint.com)");
            }
            for (Toml mob : mobArray) {
                ArrayList<String> mobNames = new ArrayList<String>();
                Config.getTomlArray(mob, "name", name -> mobNames.addAll(name.stream().filter(checkName -> !checkName.equals("mod:mob")).collect(Collectors.toSet())));
                if (!mobNames.isEmpty()) {
                    List<Toml> ruleArray = mob.getTables("rule");
                    if (ruleArray != null && !ruleArray.isEmpty()) {
                        mobNames.forEach(name -> Config.addMobRule(name, ruleArray));
                        continue;
                    }
                    Constants.LOG.warn("WARNING: Rules are missing for mob: {}", (Object)String.join((CharSequence)",", mobNames));
                    continue;
                }
                Constants.LOG.warn("WARNING: Mob ignored due to missing name");
            }
        } else {
            Constants.LOG.warn("WARNING: Missing config is either missing or invalid");
        }
        lastReloadedId = UUID.randomUUID();
        if (logDebug) {
            Constants.LOG.debug("Debug is on");
        }
    }

    public static void setLoggerLevel() {
        try {
            Field[] fields;
            for (Field field : fields = Constants.LOG.getClass().getDeclaredFields()) {
                String fieldName = field.getName();
                if (!fieldName.equals("logger")) continue;
                field.setAccessible(true);
                Logger loggerImpl = (Logger)field.get(Constants.LOG);
                loggerImpl.setLevel(logDebug ? Level.DEBUG : Level.INFO);
            }
        }
        catch (Exception ex) {
            Constants.LOG.error("Logger error", (Throwable)ex);
        }
    }

    private static void addMobRule(String mobName, List<Toml> ruleArray) {
        for (Toml rule : ruleArray) {
            if (rule.isEmpty()) continue;
            if (!mobs.containsKey(mobName)) {
                mobs.put(mobName, new MobEx(mobName));
            }
            AtomicReference<MobExRule> mobExRule = new AtomicReference<MobExRule>();
            mobExRule.set(new MobExRule());
            AtomicReference<String> copy = new AtomicReference<String>("");
            Config.getTomlString(rule, "copy", copy::set);
            if (!copy.get().isEmpty()) {
                for (MobExRule checkRule : Config.mobs.get((Object)mobName).rules) {
                    if (!checkRule.name.equals(copy.get())) continue;
                    mobExRule.set((MobExRule)Util.gson.fromJson(Util.gson.toJson((Object)checkRule), MobExRule.class));
                    ((MobExRule)mobExRule.get()).copy = copy.get();
                }
            }
            ((MobExRule)mobExRule.get()).name = "";
            Config.getTomlString(rule, "name", value -> {
                ((MobExRule)mobExRule.get()).name = value;
            });
            if (((MobExRule)mobExRule.get()).name.isEmpty()) {
                ((MobExRule)mobExRule.get()).name = "___INTERNAL___" + ruleCounter++;
            }
            Constants.LOG.debug("{} has a new rule: {}, copied from {}", new Object[]{mobName, ((MobExRule)mobExRule.get()).name, ((MobExRule)mobExRule.get()).copy.isEmpty() ? "<n/a>" : ((MobExRule)mobExRule.get()).copy});
            ((MobExRule)mobExRule.get()).mobExName = mobName;
            Config.getTomlArray(rule, "type", value -> {
                ((MobExRule)mobExRule.get()).type = value;
            });
            if (((MobExRule)mobExRule.get()).type == null || ((MobExRule)mobExRule.get()).type.isEmpty()) {
                ((MobExRule)mobExRule.get()).type = new ArrayList<String>(List.of("all"));
            }
            ((MobExRule)mobExRule.get()).type.forEach(type -> {
                if (!Constants.ruleTypes.contains(type)) {
                    Constants.LOG.warn("WARNING: Rule has an invalid type of {}", type);
                }
            });
            Config.getTomlInteger(rule, "run", value -> {
                ((MobExRule)mobExRule.get()).run = value;
            });
            if (((MobExRule)mobExRule.get()).run == null) {
                ((MobExRule)mobExRule.get()).run = 100;
            }
            Config.getTomlRange(rule, "repeat", value -> {
                ((MobExRule)mobExRule.get()).repeatFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).repeatTo = value.getMaximum();
            });
            Config.getTomlRange(rule, "day", value -> {
                ((MobExRule)mobExRule.get()).dayFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).dayTo = value.getMaximum();
            });
            Config.getTomlRange(rule, "time-of-day", value -> {
                ((MobExRule)mobExRule.get()).timeOfDayFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).timeOfDayTo = value.getMaximum();
            });
            if (((MobExRule)mobExRule.get()).timeOfDayFrom != null && ((MobExRule)mobExRule.get()).timeOfDayFrom > 24000) {
                ((MobExRule)mobExRule.get()).timeOfDayFrom = 24000;
            }
            if (((MobExRule)mobExRule.get()).timeOfDayTo != null && ((MobExRule)mobExRule.get()).timeOfDayTo > 24000) {
                ((MobExRule)mobExRule.get()).timeOfDayTo = 24000;
            }
            Config.getTomlRange(rule, "light_sky", value -> {
                ((MobExRule)mobExRule.get()).lightSkyFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).lightSkyTo = value.getMaximum();
            });
            if (((MobExRule)mobExRule.get()).lightSkyFrom != null) {
                if (((MobExRule)mobExRule.get()).lightSkyFrom > 15) {
                    ((MobExRule)mobExRule.get()).lightSkyFrom = 15;
                }
                if (((MobExRule)mobExRule.get()).lightSkyTo > 15) {
                    ((MobExRule)mobExRule.get()).lightSkyTo = 15;
                }
            }
            Config.getTomlRange(rule, "light_block", value -> {
                ((MobExRule)mobExRule.get()).lightBlockFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).lightBlockTo = value.getMaximum();
            });
            if (((MobExRule)mobExRule.get()).lightBlockFrom != null) {
                if (((MobExRule)mobExRule.get()).lightBlockFrom > 15) {
                    ((MobExRule)mobExRule.get()).lightBlockFrom = 15;
                }
                if (((MobExRule)mobExRule.get()).lightBlockTo > 15) {
                    ((MobExRule)mobExRule.get()).lightBlockTo = 15;
                }
            }
            Config.getTomlInteger(rule, "max-per-mob", value -> {
                ((MobExRule)mobExRule.get()).maxPerMob = value;
            });
            Config.getTomlInteger(rule, "max-per-player", value -> {
                ((MobExRule)mobExRule.get()).maxPerPlayer = value;
            });
            Config.getTomlArray(rule, "dimension", value -> {
                ((MobExRule)mobExRule.get()).dimension = value;
            });
            Config.getTomlArray(rule, "biome", value -> {
                ((MobExRule)mobExRule.get()).biome = value;
            });
            Config.getTomlArray(rule, "biome-tag", value -> {
                ((MobExRule)mobExRule.get()).biomeTag = value;
            });
            Config.getTomlArray(rule, "structure", value -> {
                ((MobExRule)mobExRule.get()).structure = value;
            });
            Config.getTomlArray(rule, "weather", value -> {
                ((MobExRule)mobExRule.get()).weather = value;
            });
            Config.getTomlInteger(rule, "spawn.additional-checks", value -> {
                ((MobExRule)mobExRule.get()).spawn.additionalChecks = value != 0;
            });
            Config.getTomlRange(rule, "spawn.count", value -> {
                ((MobExRule)mobExRule.get()).spawn.countFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).spawn.countTo = value.getMaximum();
            });
            Config.getTomlRange(rule, "spawn.distance-x", value -> {
                ((MobExRule)mobExRule.get()).spawn.distanceXFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).spawn.distanceXTo = value.getMaximum();
            });
            if (((MobExRule)mobExRule.get()).spawn.distanceXFrom == null || ((MobExRule)mobExRule.get()).spawn.distanceXTo == null) {
                ((MobExRule)mobExRule.get()).spawn.distanceXFrom = 50;
                ((MobExRule)mobExRule.get()).spawn.distanceXTo = 256;
            }
            Config.getTomlInteger(rule, "spawn.distance-y", value -> {
                ((MobExRule)mobExRule.get()).spawn.distanceY = value;
            });
            if (((MobExRule)mobExRule.get()).spawn.distanceY == null) {
                ((MobExRule)mobExRule.get()).spawn.distanceY = 0;
            }
            if (((MobExRule)mobExRule.get()).spawn.distanceY < 0) {
                ((MobExRule)mobExRule.get()).spawn.distanceY = 0;
            }
            if (((MobExRule)mobExRule.get()).spawn.distanceY > 256) {
                ((MobExRule)mobExRule.get()).spawn.distanceY = 256;
            }
            Config.getTomlRange(rule, "spawn.distance-z", value -> {
                ((MobExRule)mobExRule.get()).spawn.distanceZFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).spawn.distanceZTo = value.getMaximum();
            });
            if (((MobExRule)mobExRule.get()).spawn.distanceZFrom == null || ((MobExRule)mobExRule.get()).spawn.distanceZTo == null) {
                ((MobExRule)mobExRule.get()).spawn.distanceZFrom = 50;
                ((MobExRule)mobExRule.get()).spawn.distanceZTo = 256;
            }
            Config.getTomlRange(rule, "spawn.at-y", true, value -> {
                ((MobExRule)mobExRule.get()).spawn.atYFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).spawn.atYTo = value.getMaximum();
            });
            if (((MobExRule)mobExRule.get()).spawn.atYFrom != null && ((MobExRule)mobExRule.get()).spawn.atYFrom < -256) {
                ((MobExRule)mobExRule.get()).spawn.atYFrom = -256;
            }
            if (((MobExRule)mobExRule.get()).spawn.atYTo != null && ((MobExRule)mobExRule.get()).spawn.atYTo > 256) {
                ((MobExRule)mobExRule.get()).spawn.atYTo = 256;
            }
            if (((MobExRule)mobExRule.get()).spawn.atYFrom == null || ((MobExRule)mobExRule.get()).spawn.atYTo == null) {
                ((MobExRule)mobExRule.get()).spawn.atYFrom = -256;
                ((MobExRule)mobExRule.get()).spawn.atYTo = 256;
            }
            Config.getTomlArray(rule, "spawn.convert", value -> {
                ((MobExRule)mobExRule.get()).spawn.convert = value;
            });
            Config.getTomlArray(rule, "set.attack", value -> {
                ((MobExRule)mobExRule.get()).set.attack = value;
            });
            Config.getTomlInteger(rule, "set.baby", value -> {
                ((MobExRule)mobExRule.get()).set.baby = value;
            });
            Config.getTomlInteger(rule, "set.break-block", value -> {
                ((MobExRule)mobExRule.get()).set.breakBlock = value;
            });
            Config.getTomlInteger(rule, "set.can-lead", value -> {
                ((MobExRule)mobExRule.get()).set.canLead = value;
            });
            Config.getTomlInteger(rule, "set.climb", value -> {
                ((MobExRule)mobExRule.get()).set.climb = value;
            });
            Config.getTomlInteger(rule, "set.cut-grass", value -> {
                ((MobExRule)mobExRule.get()).set.cutGrass = value;
            });
            Config.getTomlRange(rule, "set.damage", value -> {
                ((MobExRule)mobExRule.get()).set.damageFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).set.damageTo = value.getMaximum();
            });
            Config.getTomlInteger(rule, "set.eat-plants", value -> {
                ((MobExRule)mobExRule.get()).set.eatPlants = value;
            });
            Config.getTomlInteger(rule, "set.eat-plants-heals", value -> {
                ((MobExRule)mobExRule.get()).set.eatPlantsHeals = value;
            });
            Config.getTomlRange(rule, "set.flying-speed", value -> {
                ((MobExRule)mobExRule.get()).set.flyingSpeedFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).set.flyingSpeedTo = value.getMaximum();
            });
            Config.getTomlRange(rule, "set.follow-range", value -> {
                ((MobExRule)mobExRule.get()).set.followRangeFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).set.followRangeTo = value.getMaximum();
            });
            Config.getTomlRange(rule, "set.health", value -> {
                ((MobExRule)mobExRule.get()).set.healthFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).set.healthTo = value.getMaximum();
            });
            Config.getTomlRange(rule, "set.knockback", value -> {
                ((MobExRule)mobExRule.get()).set.knockbackFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).set.knockbackTo = value.getMaximum();
            });
            Config.getTomlRange(rule, "set.movement-speed", value -> {
                ((MobExRule)mobExRule.get()).set.movementSpeedFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).set.movementSpeedTo = value.getMaximum();
            });
            Config.getTomlString(rule, "set.name", value -> {
                ((MobExRule)mobExRule.get()).set.name = value;
            }, false);
            Config.getTomlInteger(rule, "set.name-always-shown", value -> {
                ((MobExRule)mobExRule.get()).set.nameAlwaysShown = value != 0;
            });
            Config.getTomlString(rule, "set.on-hurt", value -> {
                ((MobExRule)mobExRule.get()).set.onHurt = value;
            });
            Config.getTomlInteger(rule, "set.place-block", value -> {
                ((MobExRule)mobExRule.get()).set.placeBlock = value;
            });
            Config.getTomlInteger(rule, "set.plant-flowers", value -> {
                ((MobExRule)mobExRule.get()).set.plantFlowers = value;
            });
            Config.getTomlInteger(rule, "set.plant-trees", value -> {
                ((MobExRule)mobExRule.get()).set.plantTrees = value;
            });
            Config.getTomlRange(rule, "set.size", value -> {
                ((MobExRule)mobExRule.get()).set.sizeFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).set.sizeTo = value.getMaximum();
            });
            Config.getTomlInteger(rule, "set.spread-fire", value -> {
                ((MobExRule)mobExRule.get()).set.spreadFire = value;
            });
            Config.getTomlInteger(rule, "set.sunburn", value -> {
                ((MobExRule)mobExRule.get()).set.sunburn = value;
            });
            Config.getTomlRange(rule, "set.xp", value -> {
                ((MobExRule)mobExRule.get()).set.xpFrom = value.getMinimum();
                ((MobExRule)mobExRule.get()).set.xpTo = value.getMaximum();
            });
            Config.getTomlWeighted(rule, "head", ((MobExRule)mobExRule.get()).head);
            Config.getTomlWeighted(rule, "chest", ((MobExRule)mobExRule.get()).chest);
            Config.getTomlWeighted(rule, "legs", ((MobExRule)mobExRule.get()).legs);
            Config.getTomlWeighted(rule, "feet", ((MobExRule)mobExRule.get()).feet);
            Config.getTomlWeighted(rule, "mainhand", ((MobExRule)mobExRule.get()).mainhand);
            Config.getTomlWeighted(rule, "offhand", ((MobExRule)mobExRule.get()).offhand);
            Config.getTomlWeighted(rule, "loot", ((MobExRule)mobExRule.get()).loot);
            Config.mobs.get((Object)mobName).rules.add((MobExRule)mobExRule.get());
        }
    }

    static void getTomlWeighted(Toml rule, String key, Weighted weighted) {
        boolean foundItems = false;
        List<Toml> lootArray = rule.getTables(key);
        if (lootArray != null && !lootArray.isEmpty()) {
            for (Toml loot : lootArray) {
                AtomicReference<String> lootName = new AtomicReference<String>("");
                Config.getTomlString(loot, "name", lootName::set, false);
                if (!lootName.get().isEmpty()) {
                    if (!foundItems && weighted.any()) {
                        weighted.clear();
                    }
                    foundItems = true;
                    AtomicReference<String> group = new AtomicReference<String>("");
                    Config.getTomlString(loot, "group", group::set);
                    AtomicInteger weight = new AtomicInteger(1);
                    Config.getTomlInteger(loot, "weight", weight::set);
                    AtomicReference<Integer> quantityFrom = new AtomicReference<Integer>(1);
                    AtomicReference<Integer> quantityTo = new AtomicReference<Integer>(1);
                    Config.getTomlRange(loot, "quantity", range -> {
                        quantityFrom.set(range.getMinimum());
                        quantityTo.set(range.getMinimum());
                    });
                    AtomicReference<Integer> drop = new AtomicReference<Integer>(0);
                    Config.getTomlInteger(loot, "drop", drop::set);
                    weighted.add(new WeightedItem(lootName.get(), group.get(), weight.get(), quantityFrom.get(), quantityTo.get(), drop.get()));
                    continue;
                }
                Constants.LOG.warn("WARNING: Loot name is missing");
            }
        }
    }

    static void getTomlArray(Toml table, String path, Consumer<ArrayList<String>> success) {
        try {
            Object value = table.getObject(path);
            if (value != null) {
                ArrayList<String> returnValue = new ArrayList<String>();
                if (value.getClass().equals(String.class)) {
                    String cleanValue = value.toString().trim().toLowerCase();
                    if (cleanValue.contains(",")) {
                        String[] parts;
                        for (String part2 : parts = cleanValue.split(",")) {
                            returnValue.add(part2.trim().toLowerCase());
                        }
                    } else {
                        returnValue.add(cleanValue);
                    }
                } else if (value.getClass().equals(ArrayList.class)) {
                    ((ArrayList)value).forEach(part -> returnValue.add(part.toString().trim().toLowerCase()));
                }
                if (!returnValue.isEmpty()) {
                    success.accept(returnValue);
                }
            }
        }
        catch (Exception ex) {
            Constants.LOG.warn("WARNING: Ignoring array list {}", (Object)path);
            Constants.LOG.error("getArray ERROR: {}", (Object)ex.getMessage());
        }
    }

    static void getTomlRange(Toml table, String path, Consumer<Range> success) {
        Config.getTomlRange(table, path, false, success);
    }

    static void getTomlRange(Toml table, String path, boolean allowNegative, Consumer<Range> success) {
        try {
            Object value = table.getObject(path);
            if (value != null) {
                Integer intValue1 = null;
                Integer intValue2 = null;
                if (value.getClass().equals(Long.class)) {
                    intValue1 = intValue2 = Integer.valueOf(Integer.parseInt(value.toString()));
                } else if (value.getClass().equals(String.class)) {
                    String cleanValue = value.toString().trim().toLowerCase();
                    if (cleanValue.contains(",")) {
                        String[] range = cleanValue.split(",");
                        intValue1 = Integer.parseInt(range[0]);
                        intValue2 = Integer.parseInt(range[1]);
                        if (intValue1 > intValue2) {
                            Integer intValueSave = intValue2;
                            intValue2 = intValue1;
                            intValue1 = intValueSave;
                        }
                    } else if (cleanValue.startsWith("<")) {
                        intValue1 = allowNegative ? Integer.MIN_VALUE : 0;
                        intValue2 = Integer.parseInt(cleanValue.replace("<", ""));
                    } else if (cleanValue.startsWith(">")) {
                        intValue1 = Integer.parseInt(cleanValue.replace(">", ""));
                        intValue2 = Integer.MAX_VALUE;
                    }
                } else if (value.getClass().equals(ArrayList.class) && ((ArrayList)value).size() > 1) {
                    intValue1 = Integer.parseInt(((ArrayList)value).get(0).toString());
                    intValue2 = Integer.parseInt(((ArrayList)value).get(1).toString());
                    if (intValue1 > intValue2) {
                        Integer intValueSave = intValue2;
                        intValue2 = intValue1;
                        intValue1 = intValueSave;
                    }
                } else {
                    Constants.LOG.warn("Unknown type for range: {} ({})", value.getClass(), value);
                }
                if (intValue1 != null) {
                    if (!allowNegative) {
                        if (intValue1 < 0) {
                            intValue1 = 0;
                        }
                        if (intValue2 < 0) {
                            intValue2 = 0;
                        }
                    }
                    success.accept(Range.of(intValue1, intValue2));
                }
            }
        }
        catch (Exception ex) {
            Constants.LOG.warn("WARNING: Ignoring parameter {}", (Object)path);
            Constants.LOG.error("ERROR: {}", (Object)ex.getMessage());
        }
    }

    static void getTomlInteger(Toml table, String path, Consumer<Integer> success) {
        Object value = table.getObject(path);
        if (value != null) {
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(Integer.class)) {
                success.accept((Integer)value);
            } else if (valueClass.equals(String.class)) {
                String cleanValue = value.toString().trim().toLowerCase();
                success.accept(cleanValue.equals("enable") || cleanValue.equals("true") || cleanValue.equals("yes") || cleanValue.equals("on") ? 100 : 0);
            } else if (valueClass.equals(Boolean.class)) {
                success.accept((Boolean)value != false ? 100 : 0);
            } else {
                success.accept(Integer.parseInt(value.toString()));
            }
        }
    }

    static void getTomlString(Toml table, String path, Consumer<String> success) {
        Config.getTomlString(table, path, success, true);
    }

    static void getTomlString(Toml table, String path, Consumer<String> success, boolean lowerCase) {
        Object value = table.getObject(path);
        if (value != null && value.getClass().equals(String.class)) {
            success.accept(lowerCase ? value.toString().trim().toLowerCase() : value.toString().trim());
        }
    }

    public static MobExRule findRuleByName(String name) {
        for (MobEx mobEx : mobs.values()) {
            for (MobExRule mobExRule : mobEx.rules) {
                if (mobExRule.name == null || mobExRule.name.isEmpty() || !mobExRule.name.equals(name)) continue;
                return mobExRule;
            }
        }
        return null;
    }
}

