/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.data;

import com.crackerjackbox.mobcontrol.data.WeightedItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class Weighted
implements Serializable {
    HashMap<String, Integer> groupMax = new HashMap();
    HashMap<String, ArrayList<WeightedItem>> groupItems = new HashMap();

    public boolean any() {
        return !this.groupItems.isEmpty();
    }

    public void clear() {
        this.groupItems.clear();
    }

    public boolean add(WeightedItem item) {
        this.groupMax.put(item.group(), this.groupMax.getOrDefault(item.group(), 0) + item.weight());
        this.groupItems.computeIfAbsent(item.group(), k -> new ArrayList());
        return this.groupItems.get(item.group()).add(item);
    }

    public WeightedItem getWeightedItem(String group) {
        int index;
        ArrayList weightedItems = this.groupItems.getOrDefault(group, new ArrayList());
        if (weightedItems.isEmpty()) {
            return null;
        }
        double random = Math.random() * (double)this.groupMax.get(group).intValue();
        for (index = 0; index < weightedItems.size() - 1 && !((random -= (double)((WeightedItem)weightedItems.get(index)).weight()) <= 0.0); ++index) {
        }
        return (WeightedItem)weightedItems.get(index);
    }

    public WeightedItem getWeightedItem() {
        if (this.groupMax.isEmpty()) {
            return null;
        }
        return this.getWeightedItem((String)this.groupMax.keySet().stream().findFirst().get());
    }

    public ArrayList<WeightedItem> getWeightedGroupItems() {
        ArrayList<WeightedItem> items = new ArrayList<WeightedItem>();
        for (String group : this.groupMax.keySet()) {
            items.add(this.getWeightedItem(group));
        }
        return items;
    }
}

