/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.StringValueReaderWriter;

public class Identifier {
    static final Identifier INVALID = new Identifier("", null);
    private static final String ALLOWED_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890_-.";
    private final String name;
    private final Type type;

    static Identifier from(String name, Context context) {
        boolean valid;
        Type type;
        if ((name = name.trim()).startsWith("[[")) {
            type = Type.TABLE_ARRAY;
            valid = Identifier.isValidTableArray(name, context);
        } else if (name.startsWith("[")) {
            type = Type.TABLE;
            valid = Identifier.isValidTable(name, context);
        } else {
            type = Type.KEY;
            valid = Identifier.isValidKey(name, context);
        }
        if (!valid) {
            return INVALID;
        }
        return new Identifier(Identifier.extractName(name), type);
    }

    private Identifier(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    String getName() {
        return this.name;
    }

    String getBareName() {
        if (this.isKey()) {
            return this.name;
        }
        if (this.isTable()) {
            return this.name.substring(1, this.name.length() - 1);
        }
        return this.name.substring(2, this.name.length() - 2);
    }

    boolean isKey() {
        return this.type == Type.KEY;
    }

    boolean isTable() {
        return this.type == Type.TABLE;
    }

    boolean isTableArray() {
        return this.type == Type.TABLE_ARRAY;
    }

    private static String extractName(String string) {
        boolean quoted = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            if (character == '\"' && (index == 0 || string.charAt(index - 1) != '\\')) {
                quoted = !quoted;
                stringBuilder.append('\"');
                continue;
            }
            if (!quoted && Character.isWhitespace(character)) continue;
            stringBuilder.append(character);
        }
        return StringValueReaderWriter.STRING_VALUE_READER_WRITER.replaceUnicodeCharacters(stringBuilder.toString());
    }

    private static boolean isValidKey(String name, Context context) {
        if (name.trim().isEmpty()) {
            context.errors.invalidKey(name, context.line.get());
            return false;
        }
        boolean quoted = false;
        for (int index = 0; index < name.length(); ++index) {
            char character = name.charAt(index);
            if (character == '\"' && (index == 0 || name.charAt(index - 1) != '\\')) {
                if (!quoted && index > 0 && name.charAt(index - 1) != '.') {
                    context.errors.invalidKey(name, context.line.get());
                    return false;
                }
                quoted = !quoted;
                continue;
            }
            if (quoted || ALLOWED_CHARS.indexOf(character) != -1) continue;
            context.errors.invalidKey(name, context.line.get());
            return false;
        }
        return true;
    }

    private static boolean isValidTable(String name, Context context) {
        boolean valid = name.endsWith("]");
        String trimmed = name.substring(1, name.length() - 1).trim();
        if (trimmed.isEmpty() || trimmed.charAt(0) == '.' || trimmed.endsWith(".")) {
            valid = false;
        }
        if (!valid) {
            context.errors.invalidTable(name, context.line.get());
            return false;
        }
        boolean quoted = false;
        boolean dotAllowed = false;
        boolean quoteAllowed = true;
        boolean charAllowed = true;
        for (int index = 0; index < trimmed.length(); ++index) {
            char character = trimmed.charAt(index);
            if (!valid) break;
            if (character == '\"' || character == '\'') {
                if (!quoteAllowed) {
                    valid = false;
                    continue;
                }
                if (quoted && trimmed.charAt(index - 1) != '\\') {
                    charAllowed = false;
                    dotAllowed = true;
                    quoteAllowed = false;
                    continue;
                }
                if (quoted) continue;
                quoted = true;
                quoteAllowed = true;
                continue;
            }
            if (quoted) continue;
            if (character == '.') {
                if (dotAllowed) {
                    charAllowed = true;
                    dotAllowed = false;
                    quoteAllowed = true;
                    continue;
                }
                context.errors.emptyImplicitTable(name, context.line.get());
                return false;
            }
            if (Character.isWhitespace(character)) {
                char prev = trimmed.charAt(index - 1);
                if (Character.isWhitespace(prev) || prev == '.') continue;
                charAllowed = false;
                dotAllowed = true;
                quoteAllowed = true;
                continue;
            }
            if (charAllowed && ALLOWED_CHARS.indexOf(character) > -1) {
                charAllowed = true;
                dotAllowed = true;
                quoteAllowed = false;
                continue;
            }
            valid = false;
        }
        if (!valid) {
            context.errors.invalidTable(name, context.line.get());
            return false;
        }
        return true;
    }

    private static boolean isValidTableArray(String line, Context context) {
        String trimmed;
        boolean valid = true;
        if (!line.endsWith("]]")) {
            valid = false;
        }
        if ((trimmed = line.substring(2, line.length() - 2).trim()).isEmpty() || trimmed.charAt(0) == '.' || trimmed.endsWith(".")) {
            valid = false;
        }
        if (!valid) {
            context.errors.invalidTableArray(line, context.line.get());
            return false;
        }
        boolean quoted = false;
        boolean dotAllowed = false;
        boolean quoteAllowed = true;
        boolean charAllowed = true;
        for (int index = 0; index < trimmed.length(); ++index) {
            char character = trimmed.charAt(index);
            if (!valid) break;
            if (character == '\"') {
                if (!quoteAllowed) {
                    valid = false;
                    continue;
                }
                if (quoted && trimmed.charAt(index - 1) != '\\') {
                    charAllowed = false;
                    dotAllowed = true;
                    quoteAllowed = false;
                    continue;
                }
                if (quoted) continue;
                quoted = true;
                quoteAllowed = true;
                continue;
            }
            if (quoted) continue;
            if (character == '.') {
                if (dotAllowed) {
                    charAllowed = true;
                    dotAllowed = false;
                    quoteAllowed = true;
                    continue;
                }
                context.errors.emptyImplicitTable(line, context.line.get());
                return false;
            }
            if (Character.isWhitespace(character)) {
                char prev = trimmed.charAt(index - 1);
                if (Character.isWhitespace(prev) || prev == '.' || prev == '\"') continue;
                charAllowed = false;
                dotAllowed = true;
                quoteAllowed = true;
                continue;
            }
            if (charAllowed && ALLOWED_CHARS.indexOf(character) > -1) {
                charAllowed = true;
                dotAllowed = true;
                quoteAllowed = false;
                continue;
            }
            valid = false;
        }
        if (!valid) {
            context.errors.invalidTableArray(line, context.line.get());
            return false;
        }
        return true;
    }

    private static enum Type {
        KEY,
        TABLE,
        TABLE_ARRAY;

    }
}

