/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Identifier;
import com.crackerjackbox.toml.IdentifierConverter;
import com.crackerjackbox.toml.Keys;
import com.crackerjackbox.toml.Results;
import com.crackerjackbox.toml.ValueReaders;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Toml {
    public static final boolean enabledWriter = false;
    public Map<String, Object> values = new HashMap<String, Object>();
    private static final Gson DEFAULT_GSON = new Gson();
    private final Toml defaults;

    private Toml(Toml defaults, Map<String, Object> values) {
        this.values = values;
        this.defaults = defaults;
    }

    public Toml() {
        this((Toml)null);
    }

    public Toml(Toml defaults) {
        this(defaults, new HashMap<String, Object>());
    }

    public Toml(String file) {
        this((Toml)null);
        if (file != null) {
            try {
                this.read(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            }
            catch (Exception ex) {
                Constants.LOG.error("Toml read", (Throwable)ex);
            }
        }
    }

    public Toml read(Reader reader) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader);
            StringBuilder stringBuilder = new StringBuilder();
            String line = bufferedReader.readLine();
            while (line != null) {
                stringBuilder.append(line).append('\n');
                line = bufferedReader.readLine();
            }
            this.read(stringBuilder.toString());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException ex) {
                Constants.LOG.error("Toml closing buffer", (Throwable)ex);
            }
        }
        return this;
    }

    public Toml read(Toml toml) {
        this.values = toml.values;
        return this;
    }

    public Toml read(String tomlString) throws IllegalStateException {
        Results results = this.parse(tomlString);
        if (results.errors.hasErrors()) {
            throw new IllegalStateException(results.errors.toString());
        }
        this.values = results.consume();
        return this;
    }

    Results parse(String tomlString) {
        Results results = new Results();
        if (tomlString.isEmpty()) {
            return results;
        }
        AtomicInteger atomicInteger = new AtomicInteger();
        boolean inComment = false;
        AtomicInteger line = new AtomicInteger(1);
        Identifier identifier = null;
        Object value = null;
        int index = atomicInteger.get();
        while (index < tomlString.length()) {
            char character = tomlString.charAt(index);
            if (results.errors.hasErrors()) break;
            if (character == '#' && !inComment) {
                inComment = true;
            } else if (!Character.isWhitespace(character) && !inComment && identifier == null) {
                Identifier id = IdentifierConverter.IDENTIFIER_CONVERTER.convert(tomlString, atomicInteger, new Context(null, line, results.errors));
                if (id != Identifier.INVALID) {
                    if (id.isKey()) {
                        identifier = id;
                    } else if (id.isTable()) {
                        results.startTables(id, line);
                    } else if (id.isTableArray()) {
                        results.startTableArray(id, line);
                    }
                } else {
                    Constants.LOG.warn("TOML Identifier INVALID {} : {}", (Object)id.getName(), (Object)id.getBareName());
                }
            } else if (character == '\n') {
                inComment = false;
                identifier = null;
                value = null;
                line.incrementAndGet();
            } else if (!inComment && identifier != null && identifier.isKey() && value == null && !Character.isWhitespace(character)) {
                value = ValueReaders.VALUE_READERS.convert(tomlString, atomicInteger, new Context(identifier, line, results.errors));
                if (value instanceof Results.Errors) {
                    results.errors.add((Results.Errors)value);
                } else {
                    results.addValue(identifier.getName(), value, line);
                }
            } else if (value != null && !inComment && !Character.isWhitespace(character)) {
                results.errors.invalidTextAfterIdentifier(identifier, character, line.get());
            }
            index = atomicInteger.incrementAndGet();
        }
        return results;
    }

    public Object getObject(String key) {
        return this.get(key);
    }

    public String getString(String key) {
        Object value = this.get(key);
        return value == null ? "" : value.toString();
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        return value.isEmpty() ? defaultValue : value;
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Long getLong(String key, Long defaultValue) {
        Long value = this.getLong(key);
        return value == null ? defaultValue : value;
    }

    public Integer getInteger(String key) {
        Object value = this.get(key);
        return value == null ? null : Integer.valueOf((int)((Long)value).longValue());
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Integer value = this.getInteger(key);
        return value == null ? defaultValue : value;
    }

    public <T> List<T> getList(String key) {
        List list = (List)this.get(key);
        return list;
    }

    public <T> List<T> getList(String key, List<T> defaultValue) {
        List<T> list = this.getList(key);
        return list != null ? list : defaultValue;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Boolean value = this.getBoolean(key);
        return value == null ? defaultValue : value;
    }

    public Date getDate(String key) {
        return (Date)this.get(key);
    }

    public Date getDate(String key, Date defaultValue) {
        Date value = this.getDate(key);
        return value == null ? defaultValue : value;
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public Double getDouble(String key, Double defaultValue) {
        Double value = this.getDouble(key);
        return value == null ? defaultValue : value;
    }

    public Toml getTable(String key) {
        Map map = (Map)this.get(key);
        return map != null ? new Toml(null, map) : null;
    }

    public List<Toml> getTables(String key) {
        List tableArray = (List)this.get(key);
        if (tableArray == null) {
            return null;
        }
        ArrayList<Toml> tables = new ArrayList<Toml>();
        for (Map table : tableArray) {
            tables.add(new Toml(null, table));
        }
        return tables;
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    private Object get(String key) {
        Keys.Key[] splitKeys;
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        HashMap<String, Object> current = new HashMap<String, Object>(this.values);
        for (Keys.Key splitKey : splitKeys = Keys.split(key)) {
            if (splitKey.index == -1 && current instanceof Map && ((Map)current).containsKey(splitKey.path)) {
                return ((Map)current).get(splitKey.path);
            }
            current = ((Map)current).get(splitKey.name);
            if (splitKey.index > -1 && current != null) {
                if (splitKey.index >= ((List)((Object)current)).size()) {
                    return null;
                }
                current = ((List)((Object)current)).get(splitKey.index);
            }
            if (current != null) continue;
            return this.defaults != null ? this.defaults.get(key) : null;
        }
        return current;
    }

    public String write(Object from) {
        return null;
    }

    public void write(Object from, File target) throws IOException {
    }

    public void write(Object from, Writer target) throws IOException {
    }
}

