/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityType.class})
public abstract class EntityTypeMix<T extends Entity> {
    @Inject(method={"create(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/nbt/CompoundTag;Ljava/util/function/Consumer;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/MobSpawnType;ZZ)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")})
    private void create(ServerLevel level, CompoundTag nbt, Consumer<T> consumer, BlockPos pos, MobSpawnType spawnReason, boolean shouldOffsetY, boolean shouldOffsetYMore, CallbackInfoReturnable<T> cir) {
        Entity entity = (Entity)cir.getReturnValue();
        if (!level.f_46443_ && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (spawnReason != null) {
                ((IMob)mob).mobControl$setMobSpawn(new MobSpawn(spawnReason.toString()));
            }
        }
    }

    @Inject(method={"create(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void create(CompoundTag tag, Level level, CallbackInfoReturnable<Optional<Entity>> cir) {
        cir.setReturnValue((Object)Util.m_137521_(BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation(tag.m_128461_("id"))).map(entityType -> entityType.m_20615_(level)), entity -> entity.m_20258_(tag), () -> Constants.LOG.debug("Skipping Entity with id {}", (Object)tag.m_128423_("id"))));
    }
}

