/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Config;
import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.iface.IPlayer;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMix
implements IPlayer {
    @Shadow
    @Final
    private ServerStatsCounter f_8910_;
    @Unique
    long mobControl$lastTick = 0L;

    @Override
    public long mobControl$ticks() {
        return (long)this.f_8910_.m_13015_(Stats.f_12988_.m_12902_((Object)Constants.STAT_PLAYER_DAYS)) * 24000L + (long)this.f_8910_.m_13015_(Stats.f_12988_.m_12902_((Object)Constants.STAT_PLAYER_TICKS));
    }

    @Override
    public void mobControl$setNextDay() {
        ServerPlayerMix serverPlayerMix = this;
        if (serverPlayerMix instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerMix;
            this.f_8910_.m_13023_((Player)serverPlayer, Stats.f_12988_.m_12902_((Object)Constants.STAT_PLAYER_DAYS), 1);
            this.f_8910_.m_6085_((Player)serverPlayer, Stats.f_12988_.m_12902_((Object)Constants.STAT_PLAYER_TICKS), 0);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        ServerPlayerMix serverPlayerMix = this;
        if (serverPlayerMix instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerMix;
            if ((long)serverPlayer.f_19797_ < this.mobControl$lastTick - 1000L) {
                Constants.LOG.debug("FORCED TICK RESET: {}", (Object)serverPlayer.f_19797_);
                this.mobControl$lastTick = 0L;
            }
            if ((long)serverPlayer.f_19797_ > this.mobControl$lastTick) {
                this.mobControl$lastTick = serverPlayer.f_19797_;
                this.f_8910_.m_13023_((Player)serverPlayer, Stats.f_12988_.m_12902_((Object)Constants.STAT_PLAYER_TICKS), 1);
                if (this.f_8910_.m_13015_(Stats.f_12988_.m_12902_((Object)Constants.STAT_PLAYER_TICKS)) >= 24000) {
                    this.mobControl$setNextDay();
                }
                ServerLevel serverLevel = serverPlayer.m_284548_();
                for (MobEx mobEx : Config.mobs.values()) {
                    if (mobEx.isWild() || mobEx.entityType() == null) continue;
                    BlockPos pos = serverPlayer.m_20183_();
                    long playerDays = this.mobControl$ticks() / 24000L;
                    Entity entity = mobEx.entityType().m_20615_((Level)serverLevel);
                    if (!(entity instanceof Mob)) continue;
                    Mob mob = (Mob)entity;
                    ((IMob)entity).mobControl$setMobSpawn(new MobSpawn(Constants.ReasonControl));
                    ((IMob)mob).mobControl$getMobSpawn().dayCheck = playerDays;
                    entity.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), Util.random.nextFloat() * 360.0f, 0.0f);
                    if (mob.m_21224_()) continue;
                    serverLevel.m_7967_((Entity)mob);
                }
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void die(DamageSource cause, CallbackInfo ci) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        BlockPos pos = serverPlayer.m_20183_();
        Constants.LOG.debug("Player {} died by {} @ {} {} {}", new Object[]{serverPlayer.m_5446_().getString(), cause.m_269415_().f_268677_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }
}

