/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.Context;
import com.crackerjackbox.toml.Results;
import com.crackerjackbox.toml.ValueReaders;
import com.crackerjackbox.toml.iface.IValueReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ArrayValueReader
implements IValueReader {
    static final ArrayValueReader ARRAY_VALUE_READER = new ArrayValueReader();

    @Override
    public boolean canRead(String string) {
        return string.startsWith("[");
    }

    @Override
    public Object read(String string, AtomicInteger atomicInteger, Context context) {
        AtomicInteger line = context.line;
        int startLine = line.get();
        int startIndex = atomicInteger.get();
        ArrayList<Object> arrayItems = new ArrayList<Object>();
        boolean terminated = false;
        boolean inComment = false;
        Results.Errors errors = new Results.Errors();
        int index = atomicInteger.incrementAndGet();
        while (index < string.length()) {
            char character = string.charAt(index);
            if (character == '#' && !inComment) {
                inComment = true;
            } else if (character == '\n') {
                inComment = false;
                line.incrementAndGet();
            } else if (!inComment && !Character.isWhitespace(character) && character != ',') {
                if (character == '[') {
                    converted = this.read(string, atomicInteger, context);
                    if (converted instanceof Results.Errors) {
                        errors.add((Results.Errors)converted);
                    } else if (this.isNotAssignable(converted, arrayItems)) {
                        errors.notAssignable(context.identifier.getName(), line.get());
                    } else {
                        arrayItems.add(converted);
                    }
                } else {
                    if (character == ']') {
                        terminated = true;
                        break;
                    }
                    converted = ValueReaders.VALUE_READERS.convert(string, atomicInteger, context);
                    if (converted instanceof Results.Errors) {
                        errors.add((Results.Errors)converted);
                    } else if (this.isNotAssignable(converted, arrayItems)) {
                        errors.notAssignable(context.identifier.getName(), line.get());
                    } else {
                        arrayItems.add(converted);
                    }
                }
            }
            index = atomicInteger.incrementAndGet();
        }
        if (!terminated) {
            errors.unterminated(context.identifier.getName(), string.substring(startIndex, string.length()), startLine);
        }
        return errors.hasErrors() ? errors : arrayItems;
    }

    private boolean isNotAssignable(Object object, List<?> values) {
        return !values.isEmpty() && !values.get(0).getClass().isAssignableFrom(object.getClass()) && !object.getClass().isAssignableFrom(values.get(0).getClass());
    }
}

