/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.ValueWriters;
import com.crackerjackbox.toml.iface.IValueWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;

public abstract class ArrayValueWriter
implements IValueWriter {
    protected static boolean isCollectionOrArray(Object value) {
        return value instanceof Collection || value.getClass().isArray();
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    static boolean isArrayOfPrimitive(Object array) {
        Object first = ArrayValueWriter.peek(array);
        if (first != null) {
            IValueWriter valueWriter = ValueWriters.WRITERS.findWriterFor(first);
            return valueWriter.isPrimitiveType() || ArrayValueWriter.isCollectionOrArray(first);
        }
        return true;
    }

    protected Collection<?> normalize(Object value) {
        ArrayList<Object> collection;
        if (value.getClass().isArray()) {
            collection = new ArrayList<Object>(Array.getLength(value));
            for (int index = 0; index < Array.getLength(value); ++index) {
                Object elem = Array.get(value, index);
                collection.add(elem);
            }
        } else {
            collection = (ArrayList<Object>)value;
        }
        return collection;
    }

    private static Object peek(Object value) {
        if (value.getClass().isArray()) {
            if (Array.getLength(value) > 0) {
                return Array.get(value, 0);
            }
            return null;
        }
        Collection collection = (Collection)value;
        if (!collection.isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }
}

