/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.mobcontrol.mixin;

import com.crackerjackbox.mobcontrol.Constants;
import com.crackerjackbox.mobcontrol.Util;
import com.crackerjackbox.mobcontrol.ai.BreakBlocksGoal;
import com.crackerjackbox.mobcontrol.ai.GenericAttackGoal;
import com.crackerjackbox.mobcontrol.ai.GenericHurtByTargetGoal;
import com.crackerjackbox.mobcontrol.data.MobSpawn;
import com.crackerjackbox.mobcontrol.data.Weighted;
import com.crackerjackbox.mobcontrol.data.WeightedItem;
import com.crackerjackbox.mobcontrol.iface.IMob;
import com.crackerjackbox.mobcontrol.rule.MobEx;
import com.crackerjackbox.mobcontrol.rule.MobExRule;
import com.crackerjackbox.mobcontrol.rule.MobExSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2526;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4638;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1308.class})
public abstract class MobMix
implements IMob {
    @Unique
    private MobSpawn mobControl$mobSpawn = null;
    @Unique
    private MobExRule mobControl$mobExRule = null;
    @Unique
    private long mobControl$lastPlacedTick = 0L;
    @Unique
    private boolean mobControl$cancelBossFight = false;
    @Shadow
    protected int field_6194;
    @Shadow
    @Final
    protected class_1355 field_6185;
    @Shadow
    @Final
    protected class_1355 field_6201;
    @Shadow
    protected class_1408 field_6189;
    @Unique
    private final ArrayList<class_1308> mobControl$secondaryMobs = new ArrayList();
    @Unique
    private final ArrayList<WeightedItem> mobControl$deathLoot = new ArrayList();

    @Shadow
    public abstract class_1309 method_5968();

    @Shadow
    public abstract void method_47825(Predicate<class_1352> var1);

    @Shadow
    public abstract void method_5980(@Nullable class_1309 var1);

    @Override
    @Unique
    public MobSpawn mobControl$getMobSpawn() {
        return this.mobControl$mobSpawn;
    }

    @Override
    @Unique
    public void mobControl$setMobSpawn(MobSpawn value) {
        this.mobControl$mobSpawn = value;
    }

    @Override
    @Unique
    public MobExRule mobControl$getRule() {
        return this.mobControl$mobExRule;
    }

    @Override
    @Unique
    public void mobControl$setRule(MobExRule value) {
        this.mobControl$mobExRule = (MobExRule)Util.gson.fromJson(Util.gson.toJson((Object)value), MobExRule.class);
    }

    @Override
    public void mobControl$addMob(class_1308 newMob) {
        this.mobControl$secondaryMobs.add(newMob);
    }

    @Override
    public void mobControl$addDeathLoot(WeightedItem weightedItem) {
        this.mobControl$deathLoot.add(weightedItem);
    }

    @Override
    @Unique
    public void mobControl$setCancelBossFight(boolean value) {
        this.mobControl$cancelBossFight = value;
    }

    @Override
    @Unique
    public boolean mobControl$getCancelBossFight() {
        return this.mobControl$cancelBossFight;
    }

    @Inject(method={"convertTo"}, at={@At(value="RETURN")})
    private <T extends class_1308> void convertTo(class_1299<T> entityType, boolean transferInventory, CallbackInfoReturnable<T> cir) {
        Object object = cir.getReturnValue();
        if (object instanceof class_1308) {
            class_1308 convertedMob = (class_1308)object;
            if (this.mobControl$mobExRule != null) {
                ((IMob)convertedMob).mobControl$setRule(this.mobControl$mobExRule);
                ((IMob)convertedMob).mobControl$getRule().converting = true;
            }
        }
    }

    @Inject(method={"dropCustomDeathLoot"}, at={@At(value="HEAD")}, cancellable=true)
    protected void dropCustomDeathLoot(class_3218 serverLevel, class_1282 damageSource, boolean recentlyHit, CallbackInfo ci) {
        MobExRule mobExRule;
        class_1308 mob = (class_1308)this;
        if (mob.method_24515() != null && (mobExRule = this.mobControl$getRule()) != null) {
            if (mobExRule.loot != null && mobExRule.loot.any()) {
                Constants.LOG.debug("Dropping loot for {}", (Object)mobExRule.mobExName);
                mobExRule.loot.getWeightedGroupItems().forEach(loot -> this.mobControl$dropItem(serverLevel, mob.method_24515(), (WeightedItem)loot));
                ci.cancel();
            }
            if (!this.mobControl$deathLoot.isEmpty()) {
                this.mobControl$deathLoot.forEach(loot -> {
                    if (MobEx.can(loot.drop())) {
                        this.mobControl$dropItem(serverLevel, mob.method_24515(), (WeightedItem)loot);
                        ci.cancel();
                    }
                });
            }
        }
        if (this.mobControl$cancelBossFight && serverLevel.method_29198() != null) {
            serverLevel.method_29198().method_12528(null);
        }
    }

    @Unique
    private void mobControl$dropItem(class_3218 level, class_2338 position, WeightedItem loot) {
        class_1799 itemStack;
        if (loot.quantityTo() != 0 && (itemStack = Util.getRandomItemStack(level, loot)) != null) {
            itemStack.method_7939(MobEx.randomFromRange(loot.quantityFrom(), loot.quantityTo()));
            class_1542 itemEntity = new class_1542((class_1937)level, (double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260(), itemStack);
            itemEntity.method_6988();
            level.method_8649((class_1297)itemEntity);
        }
    }

    @Inject(method={"createMobAttributes"}, at={@At(value="RETURN")}, cancellable=true)
    private static void createMobAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        cir.setReturnValue((Object)((class_5132.class_5133)cir.getReturnValue()).method_26867(class_5134.field_23721));
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void setTarget(class_1309 target, CallbackInfo ci) {
        class_1308 mob;
        if (this.mobControl$mobExRule.set.attack != null && !this.mobControl$mobExRule.set.attack.contains("player") && !((mob = (class_1308)this).method_6065() instanceof class_1657) && target instanceof class_1657) {
            ci.cancel();
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void baseTick(CallbackInfo ci) {
        class_1308 mob = (class_1308)this;
        if (this.mobControl$mobExRule != null) {
            this.mobControl$mobExRule.currentHealth = mob.method_6032();
            if (!this.mobControl$mobExRule.hasLoaded) {
                MobMix mobMix;
                Object pathfinderMob;
                class_1324 attribute;
                class_1297 entity;
                Object newMobType;
                this.mobControl$mobExRule.hasLoaded = true;
                Constants.LOG.debug("setMob: Finalizing {}, rule {}", (Object)mob.method_5477().getString(), (Object)this.mobControl$mobExRule.name);
                if (this.mobControl$mobExRule.spawn.convert != null && ((Optional)(newMobType = class_1299.method_5898((String)Util.getRandomElement(this.mobControl$mobExRule.spawn.convert)))).isPresent() && mob.method_5864() != ((Optional)newMobType).get() && (entity = ((class_1299)((Optional)newMobType).get()).method_5883(mob.method_37908())) instanceof IMob) {
                    IMob iMob = (IMob)entity;
                    iMob.mobControl$setRule(this.mobControl$mobExRule);
                    iMob.mobControl$setMobSpawn(new MobSpawn(class_3730.field_16468.toString()));
                    ((class_1308)iMob).method_33574(mob.method_19538());
                    if (mob.method_5864().equals(class_1299.field_6116)) {
                        iMob.mobControl$setCancelBossFight(true);
                    }
                    mob.method_37908().method_8649(entity);
                    mob.method_31472();
                    mob.method_6033(0.0f);
                }
                mob.method_38785();
                if (!this.mobControl$secondaryMobs.isEmpty()) {
                    for (class_1308 newMob : this.mobControl$secondaryMobs) {
                        if (mob.method_29504()) {
                            newMob.method_31472();
                            newMob.method_6033(0.0f);
                            continue;
                        }
                        newMob.method_33574(mob.method_19538());
                        mob.method_37908().method_8649((class_1297)newMob);
                    }
                    this.mobControl$secondaryMobs.clear();
                }
                if (mob instanceof class_1429) {
                    Util.setRandomItem(mob, class_1304.field_48824, this.mobControl$mobExRule.chest);
                }
                Util.setRandomItem(mob, class_1304.field_6169, this.mobControl$mobExRule.head);
                Util.setRandomItem(mob, class_1304.field_6174, this.mobControl$mobExRule.chest);
                Util.setRandomItem(mob, class_1304.field_6172, this.mobControl$mobExRule.legs);
                Util.setRandomItem(mob, class_1304.field_6166, this.mobControl$mobExRule.feet);
                Util.setRandomItem(mob, class_1304.field_6173, this.mobControl$mobExRule.mainhand);
                Util.setRandomItem(mob, class_1304.field_6171, this.mobControl$mobExRule.offhand);
                if (this.mobControl$mobExRule.set.baby != null) {
                    mob.method_7217(MobEx.can(this.mobControl$mobExRule.set.baby));
                }
                if (this.mobControl$mobExRule.set.xpFrom != null) {
                    this.field_6194 = MobEx.randomFromRange(this.mobControl$mobExRule.set.xpFrom, this.mobControl$mobExRule.set.xpTo);
                }
                if (this.mobControl$mobExRule.set.healthFrom != null && (attribute = mob.method_6127().method_45329(class_5134.field_23716)) != null) {
                    if (this.mobControl$mobExRule.maxHealth == 0.0f) {
                        Constants.LOG.debug("Setting MAX_HEALTH mobControl$mobExRule.maxHealth == {}", (Object)Float.valueOf(this.mobControl$mobExRule.maxHealth));
                        this.mobControl$mobExRule.currentHealth = this.mobControl$mobExRule.maxHealth = (float)MobEx.randomFromRange(this.mobControl$mobExRule.set.healthFrom, this.mobControl$mobExRule.set.healthTo);
                    }
                    Constants.LOG.debug("Setting MAX_HEALTH XX cur {}, max b4 {}, ruleTo {}", new Object[]{Float.valueOf(this.mobControl$mobExRule.currentHealth), attribute.method_6194(), this.mobControl$mobExRule.set.healthTo});
                    attribute.method_6192((double)this.mobControl$mobExRule.maxHealth);
                    mob.method_6033(this.mobControl$mobExRule.currentHealth);
                    Constants.LOG.debug("Setting MAX_HEALTH to {} with current of {} for {}", new Object[]{mob.method_6127().method_26852(class_5134.field_23716), Float.valueOf(mob.method_6032()), this.mobControl$mobExRule.mobExName});
                }
                if (this.mobControl$mobExRule.set.damageFrom != null && (attribute = mob.method_6127().method_45329(class_5134.field_23721)) != null) {
                    attribute.method_6192((double)MobEx.randomFromRange(this.mobControl$mobExRule.set.damageFrom, this.mobControl$mobExRule.set.damageTo));
                    Constants.LOG.debug("Setting ATTACK_DAMAGE to {} for {}", (Object)mob.method_6127().method_26852(class_5134.field_23721), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.knockbackFrom != null && (attribute = mob.method_6127().method_45329(class_5134.field_23722)) != null) {
                    attribute.method_6192((double)MobEx.randomFromRange(this.mobControl$mobExRule.set.knockbackFrom, this.mobControl$mobExRule.set.knockbackTo));
                    Constants.LOG.debug("Setting ATTACK_KNOCKBACK to {} for {}", (Object)mob.method_6127().method_26852(class_5134.field_23722), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.movementSpeedFrom != null && (attribute = mob.method_6127().method_45329(class_5134.field_23719)) != null) {
                    attribute.method_6192(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.movementSpeedFrom, this.mobControl$mobExRule.set.movementSpeedTo));
                    Constants.LOG.debug("Setting MOVEMENT_SPEED to {} for {}", (Object)mob.method_6127().method_26852(class_5134.field_23719), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.flyingSpeedFrom != null && (attribute = mob.method_6127().method_45329(class_5134.field_23720)) != null) {
                    attribute.method_6192(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.flyingSpeedFrom, this.mobControl$mobExRule.set.flyingSpeedTo));
                    Constants.LOG.debug("Setting FLYING_SPEED to {} for {}", (Object)mob.method_6127().method_26852(class_5134.field_23720), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.sizeFrom != null && (attribute = mob.method_6127().method_45329(class_5134.field_47760)) != null) {
                    attribute.method_6192(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.sizeFrom, this.mobControl$mobExRule.set.sizeTo));
                    mob.method_18382();
                    Constants.LOG.debug("Setting.SCALE to {} for {}", (Object)mob.method_6127().method_26852(class_5134.field_47760), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.followRangeFrom != null && (attribute = mob.method_6127().method_45329(class_5134.field_23717)) != null) {
                    attribute.method_6192(0.01 * (double)MobEx.randomFromRange(this.mobControl$mobExRule.set.followRangeFrom, this.mobControl$mobExRule.set.followRangeTo));
                    Constants.LOG.debug("Setting.FOLLOW_RANGE to {} for {}", (Object)mob.method_6127().method_26852(class_5134.field_23717), (Object)this.mobControl$mobExRule.mobExName);
                }
                if (this.mobControl$mobExRule.set.name != null && !this.mobControl$mobExRule.set.name.isEmpty()) {
                    mob.method_5665((class_2561)class_2561.method_43470((String)this.mobControl$mobExRule.set.name));
                }
                mob.method_5880(this.mobControl$mobExRule.set.nameAlwaysShown);
                if (this.mobControl$mobExRule.set.onHurt != null && !this.mobControl$mobExRule.set.onHurt.isEmpty()) {
                    this.method_47825(goal -> goal instanceof class_1366 || goal instanceof class_1399);
                    if (mob instanceof class_1314) {
                        pathfinderMob = (class_1314)mob;
                        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)pathfinderMob, 1.2, true));
                        this.field_6185.method_6277(1, (class_1352)(this.mobControl$mobExRule.set.onHurt.equals("all") ? new class_1399((class_1314)pathfinderMob, new Class[0]).method_6318(new Class[0]) : new class_1399((class_1314)pathfinderMob, new Class[0])));
                    } else {
                        this.field_6201.method_6277(1, (class_1352)new GenericAttackGoal(mob));
                        this.field_6185.method_6277(1, (class_1352)(this.mobControl$mobExRule.set.onHurt.equals("all") ? new GenericHurtByTargetGoal(mob).setAlertOthers() : new GenericHurtByTargetGoal(mob)));
                    }
                }
                if (this.mobControl$mobExRule.set.attack != null) {
                    this.method_47825(goal -> goal instanceof class_1366 || goal instanceof class_1400);
                    if (mob instanceof class_1314) {
                        pathfinderMob = (class_1314)mob;
                        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)pathfinderMob, 1.2, true));
                    } else {
                        this.field_6201.method_6277(1, (class_1352)new GenericAttackGoal(mob));
                    }
                    this.method_5980(null);
                    for (String mobToAttack : this.mobControl$mobExRule.set.attack) {
                        if (mobToAttack.equals("player")) {
                            this.field_6185.method_6277(1, (class_1352)new class_1400(mob, class_1657.class, true, livingEntity -> livingEntity instanceof class_1657));
                            continue;
                        }
                        Optional optional = class_1299.method_5898((String)mobToAttack);
                        if (!optional.isPresent()) continue;
                        class_1299 entityType = (class_1299)optional.get();
                        if (mob.method_5864().equals(entityType)) continue;
                        this.field_6185.method_6277(1, (class_1352)new class_1400(mob, class_1308.class, true, livingEntity -> livingEntity.method_5864() == entityType));
                    }
                }
                if (MobEx.can(this.mobControl$mobExRule.set.breakBlock) && (mobMix = this) instanceof class_1588) {
                    class_1588 monster = (class_1588)mobMix;
                    this.field_6201.method_6277(1, new BreakBlocksGoal<class_1588>(monster));
                }
            }
            if (this.mobControl$mobExRule.set.climbFallTicks != null) {
                MobExSet mobExSet = this.mobControl$mobExRule.set;
                mobExSet.climbFallTicks = mobExSet.climbFallTicks - 1;
                if (mobExSet.climbFallTicks > 0) {
                    mob.method_38785();
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void addAdditionalSaveData(class_2487 compound, CallbackInfo ci) {
        if (this.mobControl$mobExRule != null) {
            String json = Util.gson.toJson((Object)this.mobControl$mobExRule);
            compound.method_10582("mobcontrol:rule", json);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readAdditionalSaveData(class_2487 compound, CallbackInfo ci) {
        if (this.mobControl$mobExRule == null) {
            String json = compound.method_10558("mobcontrol:rule");
            if (!json.isEmpty()) {
                this.mobControl$setRule((MobExRule)Util.gson.fromJson(json, MobExRule.class));
                this.mobControl$mobExRule.hasLoaded = false;
            }
        } else {
            this.mobControl$mobExRule.hasLoaded = false;
        }
    }

    @Inject(method={"isSunBurnTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void isSunBurnTick(CallbackInfoReturnable<Boolean> cir) {
        if (this.mobControl$mobExRule != null && this.mobControl$mobExRule.set.sunburn != null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean mobControl$blockPosContains(class_2338 pos, class_2338 pos1, class_2338 pos2) {
        return pos.method_10263() >= Math.min(pos1.method_10263(), pos2.method_10263()) && pos.method_10263() <= Math.max(pos1.method_10263(), pos2.method_10263()) && pos.method_10260() >= Math.min(pos1.method_10260(), pos2.method_10260()) && pos.method_10260() <= Math.max(pos1.method_10260(), pos2.method_10260());
    }

    @Inject(method={"customServerAiStep"}, at={@At(value="HEAD")})
    private void customServerAiStep(CallbackInfo ci) {
        List list;
        class_2248 footBlock;
        class_3218 serverLevel;
        class_1308 mob;
        block30: {
            block29: {
                mob = (class_1308)this;
                class_1937 class_19372 = mob.method_37908();
                if (!(class_19372 instanceof class_3218)) break block29;
                serverLevel = (class_3218)class_19372;
                if (mob != null) break block30;
            }
            return;
        }
        MobExRule mobExRule = this.mobControl$getRule();
        if (mobExRule == null) {
            if (!Util.setMob(serverLevel, mob, mob.method_23317(), mob.method_23318(), mob.method_23321())) {
                Constants.LOG.debug("*WARN* AI: mobExRule == null, type {}, id {} @ {} {} {}", new Object[]{mob.method_5864(), mob.method_5667(), mob.method_24515().method_10263(), mob.method_24515().method_10264(), mob.method_24515().method_10260()});
                mob.method_31472();
                mob.method_6033(0.0f);
            }
            return;
        }
        if (mobExRule.converting) {
            Constants.LOG.debug("AI: mobExRule.converting");
            mobExRule.converting = false;
            if (!Util.isValidMob(serverLevel, mob, class_3730.field_16468.toString())) {
                mob.method_5768();
            }
            return;
        }
        class_243 mobVector = new class_243(mob.method_23317(), mob.method_23318(), mob.method_23321());
        class_1309 target = this.method_5968();
        class_2338 aboveMob = class_2338.method_49637((double)mob.method_23317(), (double)mob.method_23320(), (double)mob.method_23321()).method_10084();
        class_2338 mobFootPos = class_2338.method_49637((double)mob.method_23317(), (double)mob.method_23318(), (double)mob.method_23321());
        int lightLevel = serverLevel.method_22339(aboveMob);
        if (serverLevel.method_8530() && MobEx.can(mobExRule.set.sunburn) && lightLevel > 7 && !mob.method_5721() && !mob.field_27857 && !mob.field_28628 && serverLevel.method_8311(aboveMob)) {
            class_1799 itemstack = mob.method_6118(class_1304.field_6169);
            if (!itemstack.method_7960()) {
                if (itemstack.method_7963()) {
                    class_1792 item = itemstack.method_7909();
                    itemstack.method_7974(itemstack.method_7919() + Util.random.nextInt(2));
                    if (itemstack.method_7919() >= itemstack.method_7936()) {
                        mob.method_20235(item, class_1304.field_6169);
                        mob.method_5673(class_1304.field_6169, class_1799.field_8037);
                    }
                }
            } else {
                mob.method_5639(7.0f);
            }
        }
        if (MobEx.can(mobExRule.set.eatPlants)) {
            mob.method_23667(class_1268.field_5808, true);
            footBlock = serverLevel.method_8320(mobFootPos).method_26204();
            if (MobMix.mobControl$isBush(footBlock) || MobMix.mobControl$isCrop(footBlock)) {
                serverLevel.method_22352(mobFootPos, false);
                if (MobEx.can(mobExRule.set.eatPlantsHeals)) {
                    mob.method_6092(new class_1293(class_1294.field_5924, 75, 0));
                }
            }
        }
        if (MobEx.can(mobExRule.set.plantFlowers) && class_3031.method_23396((class_2680)serverLevel.method_8320(mobFootPos.method_10074())) && mobFootPos.method_10264() > 0 && mobFootPos.method_10264() < 256 && !MobMix.mobControl$isBlockBadSoil(serverLevel, mobFootPos, true) && !(list = ((class_1959)serverLevel.method_23753(mobFootPos).comp_349()).method_30970().method_30982()).isEmpty()) {
            class_6880 holder = ((class_4638)((class_2975)list.getFirst()).comp_333()).comp_155();
            ((class_6796)holder.comp_349()).method_39644((class_5281)serverLevel, serverLevel.method_14178().method_12129(), serverLevel.field_9229, mobFootPos);
        }
        if (MobEx.can(mobExRule.set.plantTrees) && serverLevel.method_22385().method_22393(mobFootPos).method_40230().isPresent() && class_3031.method_23396((class_2680)serverLevel.method_8320(mobFootPos.method_10074())) && mobFootPos.method_10264() > 0 && mobFootPos.method_10264() < 256 && MobMix.mobControl$isAreaGoodSoil(serverLevel, mobFootPos)) {
            class_2960 currentBiome = ((class_5321)serverLevel.method_22385().method_22393(mobFootPos).method_40230().get()).method_29177();
            serverLevel.method_8652(mobFootPos, MobMix.mobControl$getSaplingFromBiome(currentBiome), 11);
        }
        if (MobEx.can(mobExRule.set.cutGrass)) {
            mob.method_23667(class_1268.field_5808, true);
            footBlock = serverLevel.method_8320(mobFootPos).method_26204();
            if (MobMix.mobControl$isGrass(footBlock)) {
                serverLevel.method_22352(mobFootPos, false);
            }
        }
        if (target != null && (this.field_6189.method_6357() || this.field_6189.method_31267()) && MobEx.can(mobExRule.set.placeBlock) && this.mobControl$blockPosContains(mob.method_24515(), new class_2338(target.method_24515().method_10263() - 5, 0, target.method_24515().method_10260() - 5), new class_2338(target.method_24515().method_10263() + 5, 0, target.method_24515().method_10260() + 5))) {
            class_2338 placePos = new class_2338((class_2382)mobFootPos);
            if (target.method_23318() > (double)mob.method_24515().method_10264() && !Util.isInWall(serverLevel, mob, placePos.method_46558())) {
                if (this.mobControl$lastPlacedTick + 100L < serverLevel.method_8510()) {
                    this.mobControl$lastPlacedTick = serverLevel.method_8510();
                    serverLevel.method_8652(placePos, class_2246.field_28681.method_9564(), 11);
                    mob.method_5942().method_6337((double)placePos.method_10263(), (double)placePos.method_10264(), (double)placePos.method_10260(), (double)mob.method_6029());
                }
            } else {
                class_2338 towardsTarget = class_2338.method_49637((double)(mob.method_23317() + (double)Double.compare(target.method_23317(), mob.method_23317())), (double)(mob.method_23318() + (double)Double.compare(target.method_23318(), mob.method_23318())), (double)(mob.method_23321() + (double)Double.compare(target.method_23321(), mob.method_23321())));
                boolean way = Util.random.nextDouble() > 0.5;
                placePos = new class_2338(way ? towardsTarget.method_10263() : mob.method_24515().method_10263(), mob.method_24515().method_10264(), way ? mob.method_24515().method_10260() : towardsTarget.method_10260());
                if (!Util.isInWall(serverLevel, mob, placePos.method_46558()) && this.mobControl$lastPlacedTick + 100L < serverLevel.method_8510()) {
                    this.mobControl$lastPlacedTick = serverLevel.method_8510();
                    serverLevel.method_8652(placePos, class_2246.field_28681.method_9564(), 11);
                    mob.method_5942().method_6337((double)placePos.method_10263(), (double)placePos.method_10264(), (double)placePos.method_10260(), (double)mob.method_6029());
                }
            }
        }
        List<class_1297> nearEntities = serverLevel.method_8390(class_1297.class, new class_238(mobVector, mobVector).method_1014(0.225), e -> true).stream().sorted(Comparator.comparingDouble(entity -> entity.method_5707(mobVector))).toList();
        for (class_1297 nearEntity : nearEntities) {
            if (mob.method_5628() == nearEntity.method_5628() || !(nearEntity instanceof class_1308)) continue;
            class_1308 nearMob = (class_1308)nearEntity;
            if (MobEx.can(mobExRule.set.climb) && mob.method_5968() != null && mob.method_5968().method_23318() > mob.method_23318()) {
                double rndX = Util.random.nextDouble(0.0, 0.1f) * (double)(mob.method_5968().method_23317() > mob.method_23317() ? 1 : -1);
                double rndY = Util.random.nextDouble(0.0, 0.55f) + (mob.method_6109() ? 0.25 : 0.0);
                double rndZ = Util.random.nextDouble(0.0, 0.1f) * (double)(mob.method_5968().method_23321() > mob.method_23321() ? 1 : -1);
                mob.method_18799(new class_243(rndX + mob.method_18798().method_10216(), rndY, rndZ + mob.method_18798().method_10215()));
                mob.method_23667(class_1268.field_5808, true);
                mob.method_38785();
                mobExRule.set.climbFallTicks = 20;
                if (!mob.method_6059(class_1294.field_5906)) {
                    mob.method_6092(new class_1293(class_1294.field_5906, 3, 0, false, false));
                }
            }
            if (!MobEx.can(mobExRule.set.spreadFire) || !mob.method_5809()) continue;
            if (!mob.method_6059(class_1294.field_5904)) {
                mob.method_6092(new class_1293(class_1294.field_5904, mob.method_20802(), 2, false, false));
            }
            if (nearMob == null || nearMob.method_5809()) continue;
            int remainingFireTicks = mob.method_20802();
            nearMob.method_56073(remainingFireTicks < 75 ? remainingFireTicks + Util.random.nextInt(0, 10) : remainingFireTicks);
        }
    }

    @Unique
    private static boolean mobControl$isGrass(class_2248 block) {
        return block instanceof class_2320 || block instanceof class_2526;
    }

    @Unique
    private static boolean mobControl$isBush(class_2248 block) {
        return block instanceof class_2261;
    }

    @Unique
    private static boolean mobControl$isCrop(class_2248 block) {
        return block instanceof class_2302;
    }

    @Unique
    private static boolean mobControl$isBlockBadSoil(class_3218 serverLevel, class_2338 blockPos, boolean groundCheck) {
        boolean goodGround = !groundCheck || class_3031.method_23396((class_2680)serverLevel.method_8320(blockPos.method_10074()));
        boolean canSeedPlant = MobMix.mobControl$isGrass(serverLevel.method_8320(blockPos).method_26204()) || serverLevel.method_8320(blockPos).method_26215();
        return !goodGround || !canSeedPlant;
    }

    @Unique
    private static boolean mobControl$isAreaGoodSoil(class_3218 serverLevel, class_2338 blockPos) {
        for (int checkY = 0; checkY < 5; ++checkY) {
            class_2338 checkBlockPos = new class_2338(blockPos.method_10263(), blockPos.method_10264() + checkY, blockPos.method_10260());
            if (serverLevel.method_8320(checkBlockPos).method_26215() || MobMix.mobControl$isGrass(serverLevel.method_8320(checkBlockPos).method_26204())) continue;
            return false;
        }
        for (int checkX = -2; checkX < 3; ++checkX) {
            for (int checkZ = -2; checkZ < 3; ++checkZ) {
                class_2338 checkBlockPos = new class_2338(blockPos.method_10263() + checkX, blockPos.method_10264(), blockPos.method_10260() + checkZ);
                if (!MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos, true) && !MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos.method_10084(), false) && !MobMix.mobControl$isBlockBadSoil(serverLevel, checkBlockPos.method_10084().method_10084(), false)) continue;
                return false;
            }
        }
        return true;
    }

    @Unique
    @NotNull
    private static class_2680 mobControl$getSaplingFromBiome(class_2960 currentBiome) {
        Weighted weighted = new Weighted();
        weighted.add(new WeightedItem("oak", "", 2, 1, 1, 0));
        weighted.add(new WeightedItem("birch", "", 1, 1, 1, 0));
        weighted.add(new WeightedItem("default", "", 97, 1, 1, 0));
        if (weighted.getWeightedItem().key().equals("oak")) {
            return class_2246.field_10394.method_9564();
        }
        if (weighted.getWeightedItem().key().equals("birch")) {
            return class_2246.field_10575.method_9564();
        }
        if (weighted.getWeightedItem().key().equals("default")) {
            if (currentBiome.method_12832().contains("taiga")) {
                return class_2246.field_10217.method_9564();
            }
            if (currentBiome.method_12832().contains("jungle")) {
                return class_2246.field_10276.method_9564();
            }
            if (currentBiome.method_12832().contains("savanna")) {
                return class_2246.field_10385.method_9564();
            }
            if (currentBiome.method_12832().contains("dark_forest")) {
                return class_2246.field_10160.method_9564();
            }
            if (currentBiome.method_12832().contains("cherry_grove")) {
                return class_2246.field_42727.method_9564();
            }
        }
        return Util.random.nextDouble() > 0.75 ? class_2246.field_10575.method_9564() : class_2246.field_10394.method_9564();
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")}, cancellable=true)
    private void finalizeSpawn(class_5425 level, class_1266 difficulty, class_3730 spawnReason, class_1315 spawnGroupData, CallbackInfoReturnable<class_1315> cir) {
        class_1308 mob;
        MobMix mobMix = this;
        if (mobMix instanceof class_1308 && (mob = (class_1308)mobMix).method_29504()) {
            cir.setReturnValue((Object)new class_1296.class_4697(false));
        }
    }
}

