/*
 * Decompiled with CFR 0.152.
 */
package com.crackerjackbox.toml;

import com.crackerjackbox.toml.MapValueWriter;
import com.crackerjackbox.toml.WriterContext;
import com.crackerjackbox.toml.iface.IValueWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class ObjectValueWriter
implements IValueWriter {
    static final IValueWriter OBJECT_VALUE_WRITER = new ObjectValueWriter();

    @Override
    public boolean canWrite(Object value) {
        return true;
    }

    @Override
    public void write(Object value, WriterContext context) {
        LinkedHashMap<String, Object> to = new LinkedHashMap<String, Object>();
        Set<Field> fields = ObjectValueWriter.getFields(value.getClass());
        for (Field field : fields) {
            to.put(field.getName(), ObjectValueWriter.getFieldValue(field, value));
        }
        MapValueWriter.MAP_VALUE_WRITER.write(to, context);
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    private static Set<Field> getFields(Class<?> clazz) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>(Arrays.asList(clazz.getDeclaredFields()));
        while (clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        ObjectValueWriter.removeConstantsAndSyntheticFields(fields);
        return fields;
    }

    private static void removeConstantsAndSyntheticFields(Set<Field> fields) {
        fields.removeIf(field -> Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || Modifier.isTransient(field.getModifiers()));
    }

    private static Object getFieldValue(Field field, Object object) {
        boolean isAccessible = field.canAccess(object);
        field.setAccessible(true);
        Object value = null;
        try {
            value = field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field.setAccessible(isAccessible);
        return value;
    }
}

