/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.blocks.custom.BunkerDoor;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.studio4sv.tponr.blocks.custom.BunkerDoor.BunkerDoorSubBlock;
import org.studio4sv.tponr.blocks.entity.BunkerDoor.BunkerDoorBlockEntity;
import org.studio4sv.tponr.blocks.entity.BunkerDoor.BunkerDoorSubBlockEntity;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.BunkerDoorSubsSyncS2CPacket;
import org.studio4sv.tponr.registers.ModBlocks;

public class BunkerDoorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SOLID_SHAPE = Shapes.m_83144_();
    private static final VoxelShape EMPTY_SHAPE = Shapes.m_83040_();

    public BunkerDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new BunkerDoorBlockEntity(blockPos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BunkerDoorBlockEntity) {
            ((BunkerDoorBlockEntity)blockEntity).toggleOpen();
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState oldState, boolean moved) {
        super.m_6807_(blockState, level, pos, oldState, moved);
        if (level.m_5776_()) {
            return;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        ArrayList<BlockPos> subBlockPositions = new ArrayList<BlockPos>();
        Direction rightDirection = facing.m_122427_();
        Direction leftDirection = facing.m_122428_();
        subBlockPositions.add(pos.m_121945_(leftDirection));
        subBlockPositions.add(pos.m_121945_(rightDirection));
        subBlockPositions.add(pos.m_6630_(1).m_121945_(rightDirection));
        subBlockPositions.add(pos.m_6630_(1).m_121945_(leftDirection));
        subBlockPositions.add(pos.m_6630_(2).m_121945_(rightDirection));
        subBlockPositions.add(pos.m_6630_(2).m_121945_(leftDirection));
        subBlockPositions.add(pos.m_6630_(1));
        subBlockPositions.add(pos.m_6630_(2));
        BlockState subBlockState = ((Block)ModBlocks.BUNKER_DOOR_SUB.get()).m_49966_();
        for (BlockPos subPos : subBlockPositions) {
            level.m_7731_(subPos, subBlockState, 3);
            BlockEntity be = level.m_7702_(subPos);
            if (!(be instanceof BunkerDoorSubBlockEntity)) continue;
            BunkerDoorSubBlockEntity subEntity = (BunkerDoorSubBlockEntity)be;
            subEntity.setMainBlockPos(pos);
        }
        if (!level.m_5776_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                ModMessages.sendToPlayer(new BunkerDoorSubsSyncS2CPacket(subBlockPositions, pos), player);
            }
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState state, boolean moved) {
        if (!(level.m_5776_() || moved || blockState.m_60713_(state.m_60734_()))) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            Direction rightDirection = facing.m_122427_();
            Direction leftDirection = facing.m_122428_();
            ArrayList<BlockPos> subBlockPositions = new ArrayList<BlockPos>();
            subBlockPositions.add(pos.m_121945_(leftDirection));
            subBlockPositions.add(pos.m_121945_(rightDirection));
            subBlockPositions.add(pos.m_6630_(1).m_121945_(rightDirection));
            subBlockPositions.add(pos.m_6630_(1).m_121945_(leftDirection));
            subBlockPositions.add(pos.m_6630_(2).m_121945_(rightDirection));
            subBlockPositions.add(pos.m_6630_(2).m_121945_(leftDirection));
            subBlockPositions.add(pos.m_6630_(1));
            subBlockPositions.add(pos.m_6630_(2));
            for (BlockPos subPos : subBlockPositions) {
                BlockState stateAtPos = level.m_8055_(subPos);
                if (!(stateAtPos.m_60734_() instanceof BunkerDoorSubBlock)) continue;
                level.m_7471_(subPos, false);
            }
        }
        super.m_6810_(blockState, level, pos, state, moved);
    }

    private boolean isDoorOpen(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level instanceof Level && (blockEntity = level.m_7702_(pos)) instanceof BunkerDoorBlockEntity) {
            return ((BunkerDoorBlockEntity)blockEntity).isOpen();
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SOLID_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean isDoorOpen = this.isDoorOpen(level, pos);
        return isDoorOpen ? EMPTY_SHAPE : SOLID_SHAPE;
    }
}

