/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.blocks.custom;

import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.studio4sv.tponr.blocks.entity.FilterBlockEntity;
import org.studio4sv.tponr.util.RadiationUtils;
import org.studio4sv.tponr.util.SafeAreaTracker;

public class FilterBlock
extends BaseEntityBlock {
    private static final int MAX_BLOCKS = 5000;
    private static final int BLOCKS_PER_TICK = 100;
    private static final int RESCAN_INTERVAL = 10;

    public FilterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FilterBlockEntity(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof FilterBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FilterBlockEntity be = (FilterBlockEntity)blockEntity;
        boolean enabled = be.isEnabled();
        be.setEnabled(!enabled);
        if (!pLevel.f_46443_) {
            if (!enabled) {
                be.reset();
                be.addToQueue(pPos);
                be.addToVisited(pPos);
            } else {
                be.setFinished(true);
                be.setSealed(false);
                be.setWasSealed(true);
            }
        }
        pLevel.m_186460_(pPos, pState.m_60734_(), 1);
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        if (!pState.m_60713_(pNewState.m_60734_()) && !pLevel.m_5776_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof FilterBlockEntity) {
            FilterBlockEntity be = (FilterBlockEntity)blockEntity;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                SafeAreaTracker tracker = SafeAreaTracker.get(serverLevel);
                for (BlockPos pos : be.getVisited()) {
                    tracker.removeSafeArea(pos);
                }
            }
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.f_46443_) {
            return;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof FilterBlockEntity)) {
            return;
        }
        FilterBlockEntity be = (FilterBlockEntity)blockEntity;
        SafeAreaTracker tracker = SafeAreaTracker.get(pLevel);
        if (!be.isEnabled()) {
            if (be.wasSealed()) {
                this.emitParticles(pLevel, be, (ParticleOptions)ParticleTypes.f_123762_);
                for (BlockPos pos : be.getVisited()) {
                    tracker.removeSafeArea(pos);
                }
                be.reset();
            }
            return;
        }
        if (be.isSealed() && be.isFinished() && pLevel.m_46467_() % 10L == 0L && this.hasAreaChangedAndUnsealed(pLevel, pPos, be)) {
            this.disableFilter(pLevel, be, tracker);
            return;
        }
        for (int i = 0; i < 100 && !be.getQueue().isEmpty() && !be.isFinished(); ++i) {
            if (be.getVisited().size() >= 5000) {
                be.setSealed(false);
                be.setFinished(true);
                be.setEnabled(false);
                be.getAffectedBlocks().clear();
                return;
            }
            BlockPos current = be.getQueue().poll();
            if (current == null) {
                return;
            }
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = current.m_121945_(dir);
                if (be.getVisited().contains(neighbor)) continue;
                BlockState state = pLevel.m_8055_(neighbor);
                be.addToVisited(neighbor);
                if (RadiationUtils.isSealValid(state, neighbor, (Level)pLevel)) continue;
                be.addToQueue(neighbor);
            }
        }
        if (be.getQueue().isEmpty()) {
            be.setSealed(true);
            be.setFinished(true);
            be.getAffectedBlocks().clear();
            for (BlockPos pos : be.getVisited()) {
                be.addToAffectedBlocks(pos);
            }
        }
        if (be.isFinished() && be.isSealed() && !be.wasSealed()) {
            for (BlockPos pos : be.getVisited()) {
                tracker.addSafeArea(pos);
            }
            this.emitParticles(pLevel, be, (ParticleOptions)ParticleTypes.f_123796_);
        }
        if (be.isFinished() && be.getAffectedBlocks().size() != be.getVisited().size()) {
            be.setEnabled(false);
            be.setFinished(true);
            be.reset();
            this.emitParticles(pLevel, be, (ParticleOptions)ParticleTypes.f_123762_);
        }
        be.setWasSealed(be.isSealed());
        if (be.isEnabled()) {
            pLevel.m_186460_(pPos, pState.m_60734_(), 1);
        }
    }

    private boolean hasAreaChangedAndUnsealed(ServerLevel level, BlockPos filterPos, FilterBlockEntity be) {
        HashSet<BlockPos> newVisited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(filterPos);
        newVisited.add(filterPos);
        boolean sealed = true;
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = current.m_121945_(dir);
                if (newVisited.contains(neighbor)) continue;
                BlockState state = level.m_8055_(neighbor);
                newVisited.add(neighbor);
                if (RadiationUtils.isSealValid(state, neighbor, (Level)level)) continue;
                queue.add(neighbor);
            }
            if (newVisited.size() < 5000) continue;
            queue.clear();
            sealed = false;
        }
        HashSet<BlockPos> originalVisited = new HashSet<BlockPos>(be.getVisited());
        boolean changed = !newVisited.equals(originalVisited);
        SafeAreaTracker tracker = SafeAreaTracker.get(level);
        if (changed && sealed) {
            for (BlockPos pos : be.getVisited()) {
                if (newVisited.contains(pos)) continue;
                tracker.removeSafeArea(pos);
            }
            for (BlockPos pos : newVisited) {
                if (be.getVisited().contains(pos)) continue;
                tracker.addSafeArea(pos);
            }
            be.setVisited(newVisited);
        }
        if (changed) {
            be.setVisited(newVisited);
        }
        return changed && !sealed;
    }

    private void disableFilter(ServerLevel level, FilterBlockEntity be, SafeAreaTracker tracker) {
        for (BlockPos pos : be.getVisited()) {
            tracker.removeSafeArea(pos);
        }
        be.setEnabled(false);
        be.setFinished(true);
        be.setSealed(false);
        be.setWasSealed(true);
        this.emitParticles(level, be, (ParticleOptions)ParticleTypes.f_123762_);
        be.reset();
    }

    private void emitParticles(ServerLevel level, FilterBlockEntity be, ParticleOptions particle) {
        for (BlockPos pos : be.getAffectedBlocks()) {
            level.m_8767_(particle, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.3, 0.3, 0.3, 0.01);
        }
    }
}

