/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.blocks.custom.SuitCharger;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.studio4sv.tponr.blocks.custom.SuitCharger.SuitChargerSubBlock;
import org.studio4sv.tponr.blocks.entity.SuitCharger.SuitChargerBlockEntity;
import org.studio4sv.tponr.blocks.entity.SuitCharger.SuitChargerSubBlockEntity;
import org.studio4sv.tponr.items.HazmatSuitPackItem;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.SuitChargerSubsSyncS2CPacket;
import org.studio4sv.tponr.registers.ModBlocks;
import org.studio4sv.tponr.util.RadiationUtils;

public class SuitChargerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public SuitChargerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SuitChargerBlockEntity(pPos, pState);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        SuitChargerBlockEntity chargerBlockEntity;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof SuitChargerBlockEntity && !(chargerBlockEntity = (SuitChargerBlockEntity)blockEntity).getStoredItem().m_41619_()) {
            chargerBlockEntity.addCharge(0.111f / (float)Math.max(1, RadiationUtils.levelFromPos(pPos, (Level)pLevel)));
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pBlockState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_) {
            BlockEntity blockEntity;
            if (pPlayer.m_21120_(pHand).m_41720_() instanceof HazmatSuitPackItem) {
                SuitChargerBlockEntity mainBlockEntity;
                BlockEntity blockEntity2 = pLevel.m_7702_(pPos);
                if (blockEntity2 instanceof SuitChargerBlockEntity && (mainBlockEntity = (SuitChargerBlockEntity)blockEntity2).getStoredItem().m_41619_()) {
                    mainBlockEntity.setStoredItem(pPlayer.m_21120_(pHand).m_278832_());
                    pLevel.m_186460_(pPos, (Block)this, 1);
                }
            } else if (pPlayer.m_21120_(pHand).m_41619_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof SuitChargerBlockEntity) {
                SuitChargerBlockEntity mainBlockEntity = (SuitChargerBlockEntity)blockEntity;
                pPlayer.m_21008_(pHand, mainBlockEntity.getStoredItem());
                mainBlockEntity.setStoredItem(ItemStack.f_41583_);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState oldState, boolean moved) {
        super.m_6807_(blockState, level, pos, oldState, moved);
        if (level.m_5776_()) {
            return;
        }
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        ArrayList<BlockPos> subBlockPositions = new ArrayList<BlockPos>();
        Direction leftDirection = facing.m_122427_();
        subBlockPositions.add(pos.m_121945_(leftDirection));
        subBlockPositions.add(pos.m_6630_(1).m_121945_(leftDirection));
        subBlockPositions.add(pos.m_6630_(2).m_121945_(leftDirection));
        subBlockPositions.add(pos.m_6630_(1));
        subBlockPositions.add(pos.m_6630_(2));
        subBlockPositions.add(pos.m_121945_(facing.m_122424_()));
        subBlockPositions.add(pos.m_121945_(leftDirection).m_121945_(facing.m_122424_()));
        subBlockPositions.add(pos.m_6630_(1).m_121945_(leftDirection).m_121945_(facing.m_122424_()));
        subBlockPositions.add(pos.m_6630_(2).m_121945_(leftDirection).m_121945_(facing.m_122424_()));
        subBlockPositions.add(pos.m_6630_(1).m_121945_(facing.m_122424_()));
        subBlockPositions.add(pos.m_6630_(2).m_121945_(facing.m_122424_()));
        BlockState subBlockState = ((Block)ModBlocks.SUIT_CHARGER_SUB.get()).m_49966_();
        for (BlockPos subPos : subBlockPositions) {
            level.m_7731_(subPos, subBlockState, 3);
            BlockEntity blockEntity = level.m_7702_(subPos);
            if (!(blockEntity instanceof SuitChargerSubBlockEntity)) continue;
            SuitChargerSubBlockEntity subBlockEntity = (SuitChargerSubBlockEntity)blockEntity;
            subBlockEntity.setMainBlockPos(pos);
            level.m_7260_(subPos, subBlockState, subBlockState, 3);
        }
        for (Player player : level.m_6907_()) {
            if (!(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModMessages.sendToPlayer(new SuitChargerSubsSyncS2CPacket(subBlockPositions, pos), serverPlayer);
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState state, boolean moved) {
        if (!(level.m_5776_() || moved || blockState.m_60713_(state.m_60734_()))) {
            Direction facing = (Direction)blockState.m_61143_((Property)FACING);
            ArrayList<BlockPos> subBlockPositions = new ArrayList<BlockPos>();
            Direction leftDirection = facing.m_122427_();
            subBlockPositions.add(pos.m_121945_(leftDirection));
            subBlockPositions.add(pos.m_6630_(1).m_121945_(leftDirection));
            subBlockPositions.add(pos.m_6630_(2).m_121945_(leftDirection));
            subBlockPositions.add(pos.m_6630_(1));
            subBlockPositions.add(pos.m_6630_(2));
            subBlockPositions.add(pos.m_121945_(facing.m_122424_()));
            subBlockPositions.add(pos.m_121945_(leftDirection).m_121945_(facing.m_122424_()));
            subBlockPositions.add(pos.m_6630_(1).m_121945_(leftDirection).m_121945_(facing.m_122424_()));
            subBlockPositions.add(pos.m_6630_(2).m_121945_(leftDirection).m_121945_(facing.m_122424_()));
            subBlockPositions.add(pos.m_6630_(1).m_121945_(facing.m_122424_()));
            subBlockPositions.add(pos.m_6630_(2).m_121945_(facing.m_122424_()));
            for (BlockPos subPos : subBlockPositions) {
                BlockState stateAtPos = level.m_8055_(subPos);
                if (!(stateAtPos.m_60734_() instanceof SuitChargerSubBlock)) continue;
                level.m_7471_(subPos, false);
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SuitChargerBlockEntity) {
                SuitChargerBlockEntity mainBlockEntity = (SuitChargerBlockEntity)blockEntity;
                mainBlockEntity.onDestroy();
            }
        }
        super.m_6810_(blockState, level, pos, state, moved);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof SuitChargerBlockEntity) {
            SuitChargerBlockEntity charger = (SuitChargerBlockEntity)be;
            float charge = charger.getCharge();
            return Math.round(charge / 100.0f * 15.0f);
        }
        return 0;
    }
}

