/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.blocks.entity.BunkerDoor;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.BunkerDoorOpenSyncS2CPacket;
import org.studio4sv.tponr.registers.ModBlockEntities;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class BunkerDoorBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean open = false;
    private boolean changed = false;

    public BunkerDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BUNKER_DOOR_ENTITY.get(), pos, state);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("open", this.open);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("open")) {
            this.open = nbt.m_128471_("open");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("open", this.open);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("open")) {
            this.open = tag.m_128471_("open");
            this.changed = true;
        }
    }

    public void toggleOpen() {
        this.open = !this.open;
        this.changed = true;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                ModMessages.sendToPlayer(new BunkerDoorOpenSyncS2CPacket(this.m_58899_(), this.open), player);
            }
        }
    }

    public void setOpen(boolean open) {
        this.open = open;
        this.changed = true;
        this.m_6596_();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<BunkerDoorBlockEntity> state) {
        AnimationController controller = state.getController();
        if (this.changed || !controller.getAnimationState().equals((Object)AnimationController.State.RUNNING) && !controller.getAnimationState().equals((Object)AnimationController.State.PAUSED)) {
            this.changed = false;
            controller.forceAnimationReset();
            controller.setAnimation(RawAnimation.begin().then(this.open ? "open" : "close", Animation.LoopType.HOLD_ON_LAST_FRAME));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

