/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.blocks.entity;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.SyncFilterStatusS2CPacket;
import org.studio4sv.tponr.registers.ModBlockEntities;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class FilterBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean enabled = false;
    private final Set<BlockPos> visited = new HashSet<BlockPos>();
    private final Queue<BlockPos> queue = new ArrayDeque<BlockPos>();
    private final Set<BlockPos> affectedBlocks = new HashSet<BlockPos>();
    private boolean wasSealed = false;
    private boolean sealed = false;
    private boolean finished = false;
    private long lastRescanTime = 0L;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            for (Player player : this.f_58857_.m_6907_()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModMessages.sendToPlayer(new SyncFilterStatusS2CPacket(this.m_58899_(), enabled), serverPlayer);
            }
        }
        this.m_6596_();
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void setSealed(boolean sealed) {
        this.sealed = sealed;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean wasSealed() {
        return this.wasSealed;
    }

    public void setWasSealed(boolean wasSealed) {
        this.wasSealed = wasSealed;
    }

    public Queue<BlockPos> getQueue() {
        return this.queue;
    }

    public Set<BlockPos> getVisited() {
        return this.visited;
    }

    public void setVisited(Set<BlockPos> newVisited) {
        this.visited.clear();
        this.visited.addAll(newVisited);
    }

    public void addToQueue(BlockPos pos) {
        this.queue.add(pos);
    }

    public void addToVisited(BlockPos pos) {
        this.visited.add(pos);
    }

    public Set<BlockPos> getAffectedBlocks() {
        return this.affectedBlocks;
    }

    public void addToAffectedBlocks(BlockPos pos) {
        this.affectedBlocks.add(pos);
    }

    public void reset() {
        this.queue.clear();
        this.visited.clear();
        this.affectedBlocks.clear();
        this.finished = false;
        this.sealed = false;
        this.wasSealed = false;
    }

    public FilterBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.FILTER_ENTITY.get(), pPos, pBlockState);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128379_("enabled", this.enabled);
        pTag.m_128379_("sealed", this.sealed);
        pTag.m_128379_("finished", this.finished);
        pTag.m_128379_("wasSealed", this.wasSealed);
        pTag.m_128356_("lastRescanTime", this.lastRescanTime);
        if (this.visited.size() < 1000) {
            ListTag visitedList = new ListTag();
            for (BlockPos pos : this.visited) {
                CompoundTag posTag = new CompoundTag();
                posTag.m_128405_("x", pos.m_123341_());
                posTag.m_128405_("y", pos.m_123342_());
                posTag.m_128405_("z", pos.m_123343_());
                visitedList.add((Object)posTag);
            }
            pTag.m_128365_("visited", (Tag)visitedList);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.enabled = pTag.m_128471_("enabled");
        this.sealed = pTag.m_128471_("sealed");
        this.finished = pTag.m_128471_("finished");
        this.wasSealed = pTag.m_128471_("wasSealed");
        this.lastRescanTime = pTag.m_128454_("lastRescanTime");
        if (pTag.m_128425_("visited", 9)) {
            ListTag visitedList = pTag.m_128437_("visited", 10);
            this.visited.clear();
            for (int i = 0; i < visitedList.size(); ++i) {
                CompoundTag posTag = visitedList.m_128728_(i);
                BlockPos pos = new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z"));
                this.visited.add(pos);
            }
            if (this.sealed && this.finished) {
                this.affectedBlocks.clear();
                this.affectedBlocks.addAll(this.visited);
            }
        } else if (this.enabled && this.sealed && this.finished) {
            this.finished = false;
            this.sealed = false;
            this.queue.add(this.m_58899_());
            this.visited.add(this.m_58899_());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("enabled", this.enabled);
        tag.m_128379_("sealed", this.sealed);
        tag.m_128379_("finished", this.finished);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.enabled = tag.m_128471_("enabled");
        this.sealed = tag.m_128471_("sealed");
        this.finished = tag.m_128471_("finished");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<FilterBlockEntity> state) {
        AnimationController controller = state.getController();
        controller.setAnimation(RawAnimation.begin().then("on", Animation.LoopType.LOOP));
        if (this.enabled) {
            controller.setAnimationSpeed(1.0);
        } else {
            controller.setAnimationSpeed(0.0);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

