/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.blocks.entity.SuitCharger;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.studio4sv.tponr.items.HazmatSuitPackItem;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.SuitChargerDataSyncS2CPacket;
import org.studio4sv.tponr.registers.ModBlockEntities;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class SuitChargerBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private ItemStack storedItem = ItemStack.f_41583_;

    public SuitChargerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SUIT_CHARGER_ENTITY.get(), pPos, pBlockState);
    }

    public void setStoredItem(ItemStack storedItem) {
        this.storedItem = storedItem;
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                ModMessages.sendToPlayer(new SuitChargerDataSyncS2CPacket(this.m_58899_(), this.storedItem), player);
            }
        }
    }

    public ItemStack getStoredItem() {
        return this.storedItem;
    }

    public int getCharge() {
        if (this.storedItem.m_41720_() instanceof HazmatSuitPackItem) {
            return this.storedItem.m_41784_().m_128451_("charge");
        }
        return 0;
    }

    public float getChargeFloat() {
        if (this.storedItem.m_41720_() instanceof HazmatSuitPackItem) {
            return this.storedItem.m_41784_().m_128457_("charge");
        }
        return 0.0f;
    }

    public void addCharge(float charge) {
        if (this.storedItem.m_41720_() instanceof HazmatSuitPackItem) {
            float chargeToAdd = Math.max(0.0f, Math.min(this.getChargeFloat() + charge, 100.0f));
            this.storedItem.m_41784_().m_128350_("charge", chargeToAdd);
            this.m_6596_();
            if (!this.f_58857_.f_46443_) {
                for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                    ModMessages.sendToPlayer(new SuitChargerDataSyncS2CPacket(this.m_58899_(), this.storedItem), player);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<SuitChargerBlockEntity> suitChargerBlockEntityAnimationState) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        CompoundTag itemTag = new CompoundTag();
        this.storedItem.m_41739_(itemTag);
        pTag.m_128365_("StoredItem", (Tag)itemTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("StoredItem")) {
            this.storedItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("StoredItem"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        CompoundTag itemTag = new CompoundTag();
        this.storedItem.m_41739_(itemTag);
        tag.m_128365_("StoredItem", (Tag)itemTag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag pTag) {
        super.handleUpdateTag(pTag);
        if (pTag.m_128441_("StoredItem")) {
            this.storedItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("StoredItem"));
        }
    }

    public void onDestroy() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && !this.storedItem.m_41619_() && this.storedItem.m_41720_() instanceof HazmatSuitPackItem) {
            ItemEntity entity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, this.storedItem.m_41777_());
            this.f_58857_.m_7967_((Entity)entity);
            this.storedItem = ItemStack.f_41583_;
        }
    }
}

