/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.blocks.entity.SuitDyer;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import org.studio4sv.tponr.items.HazmatSuitPackItem;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.SuitDyerDataSyncS2CPacket;
import org.studio4sv.tponr.registers.ModBlockEntities;
import org.studio4sv.tponr.util.ColorUtils;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class SuitDyerBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private ItemStack storedItem = ItemStack.f_41583_;

    public SuitDyerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SUIT_DYER_ENTITY.get(), pPos, pBlockState);
    }

    public void setStoredItem(ItemStack stack) {
        this.storedItem = stack;
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                ModMessages.sendToPlayer(new SuitDyerDataSyncS2CPacket(this.m_58899_(), this.storedItem), player);
            }
        }
    }

    public ItemStack getStoredItem() {
        return this.storedItem;
    }

    public int getColor() {
        Item item = this.storedItem.m_41720_();
        if (item instanceof HazmatSuitPackItem) {
            HazmatSuitPackItem dyeable = (HazmatSuitPackItem)item;
            return dyeable.m_41121_(this.storedItem);
        }
        return 0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<SuitDyerBlockEntity> state) {
        if (this.storedItem != null && this.storedItem.m_41720_() instanceof HazmatSuitPackItem) {
            state.getController().setAnimation(RawAnimation.begin().then("on", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else {
            state.getController().setAnimation(RawAnimation.begin().then("off", Animation.LoopType.HOLD_ON_LAST_FRAME));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        CompoundTag itemTag = new CompoundTag();
        this.storedItem.m_41739_(itemTag);
        pTag.m_128365_("StoredItem", (Tag)itemTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("StoredItem")) {
            this.storedItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("StoredItem"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        CompoundTag itemTag = new CompoundTag();
        this.storedItem.m_41739_(itemTag);
        tag.m_128365_("StoredItem", (Tag)itemTag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag pTag) {
        super.handleUpdateTag(pTag);
        if (pTag.m_128441_("StoredItem")) {
            this.storedItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("StoredItem"));
        }
    }

    public boolean setColor(int color) {
        Item item = this.storedItem.m_41720_();
        if (item instanceof HazmatSuitPackItem) {
            HazmatSuitPackItem dyeable = (HazmatSuitPackItem)item;
            dyeable.m_41115_(this.storedItem, color);
            this.m_6596_();
            if (!this.f_58857_.f_46443_) {
                for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                    ModMessages.sendToPlayer(new SuitDyerDataSyncS2CPacket(this.m_58899_(), this.storedItem), player);
                }
            }
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.5f);
            int[] rgb = ColorUtils.hexToRgb(color);
            Direction facing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockStateProperties.f_61374_);
            BlockPos rightPos = this.f_58858_.m_121945_(facing.m_122428_());
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f((float)rgb[0], (float)rgb[1], (float)rgb[2]), 1.0f), (double)rightPos.m_123341_() + 0.5, (double)rightPos.m_123342_() + 1.0, (double)rightPos.m_123343_() + 0.5, 20, 0.3, 0.3, 0.3, 0.0);
            return true;
        }
        return false;
    }
}

