/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.blocks.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.studio4sv.tponr.items.HazmatSuitPackItem;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.SuitStandDataSyncS2CPacket;
import org.studio4sv.tponr.registers.ModBlockEntities;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.RenderUtils;

public class SuitStandEntity
extends BlockEntity
implements GeoBlockEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private ItemStack storedItem = ItemStack.f_41583_;

    public SuitStandEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.STAND_ENTITY.get(), pos, state);
    }

    public void setStoredItem(ItemStack stack) {
        this.storedItem = stack;
        this.m_6596_();
        if (!this.f_58857_.f_46443_) {
            for (ServerPlayer player : ((ServerLevel)this.f_58857_).m_6907_()) {
                ModMessages.sendToPlayer(new SuitStandDataSyncS2CPacket(this.m_58899_(), this.storedItem), player);
            }
        }
    }

    public ItemStack getStoredItem() {
        return this.storedItem;
    }

    public int getColor() {
        Item item = this.storedItem.m_41720_();
        if (item instanceof HazmatSuitPackItem) {
            HazmatSuitPackItem dyeable = (HazmatSuitPackItem)item;
            return dyeable.m_41121_(this.storedItem);
        }
        return 0;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        CompoundTag itemTag = new CompoundTag();
        this.storedItem.m_41739_(itemTag);
        pTag.m_128365_("StoredItem", (Tag)itemTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("StoredItem")) {
            this.storedItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("StoredItem"));
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        CompoundTag itemTag = new CompoundTag();
        this.storedItem.m_41739_(itemTag);
        tag.m_128365_("StoredItem", (Tag)itemTag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag pTag) {
        super.handleUpdateTag(pTag);
        if (pTag.m_128441_("StoredItem")) {
            this.storedItem = ItemStack.m_41712_((CompoundTag)pTag.m_128469_("StoredItem"));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<SuitStandEntity> clockEntityAnimationState) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object blockEntity) {
        return RenderUtils.getCurrentTick();
    }
}

