/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.client.gui.SuitDyerGui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.studio4sv.tponr.TPONR;
import org.studio4sv.tponr.blocks.entity.SuitDyer.SuitDyerBlockEntity;
import org.studio4sv.tponr.client.gui.SuitDyerGui.SuitDyerMenu;
import org.studio4sv.tponr.items.FakeSuitItem;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.C2S.DyerChangeColorS2CPacket;
import org.studio4sv.tponr.registers.ModItems;
import org.studio4sv.tponr.util.ColorUtils;
import org.studio4sv.tponr.util.TextOnlyButton;
import org.studio4sv.tponr.util.ui.CenteredEditBox;

public class SuitDyerScreen
extends AbstractContainerScreen<SuitDyerMenu> {
    private static final ResourceLocation TEXTURE = TPONR.id("textures/gui/suit_dyer.png");
    private EditBox redField;
    private EditBox greenField;
    private EditBox blueField;

    public SuitDyerScreen(SuitDyerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97726_ = 286;
        this.f_97727_ = 168;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.redField = this.createColorField(this.f_97735_ + 55, this.f_97736_ + 30);
        this.greenField = this.createColorField(this.f_97735_ + 55, this.f_97736_ + 51);
        this.blueField = this.createColorField(this.f_97735_ + 55, this.f_97736_ + 72);
        this.m_142416_((GuiEventListener)this.redField);
        this.m_142416_((GuiEventListener)this.greenField);
        this.m_142416_((GuiEventListener)this.blueField);
        this.redField.m_94202_(0xFF0000);
        this.greenField.m_94202_(65280);
        this.blueField.m_94202_(255);
        int[] color = ColorUtils.hexToRgb(((SuitDyerMenu)this.f_97732_).getColor());
        this.redField.m_94144_(String.valueOf(color[0]));
        this.greenField.m_94144_(String.valueOf(color[1]));
        this.blueField.m_94144_(String.valueOf(color[2]));
        TextOnlyButton redSubButton = TextOnlyButton.textOnlyBuilder((Component)Component.m_237113_((String)""), btn -> this.redField.m_94144_(String.valueOf(Math.max(0, Math.min(this.parseColor(this.redField.m_94155_()) - 1, 255))))).bounds(this.f_97735_ + 34, this.f_97736_ + 30, 16, 16).build();
        TextOnlyButton greenSubButton = TextOnlyButton.textOnlyBuilder((Component)Component.m_237113_((String)""), btn -> this.greenField.m_94144_(String.valueOf(Math.max(0, Math.min(this.parseColor(this.greenField.m_94155_()) - 1, 255))))).bounds(this.f_97735_ + 34, this.f_97736_ + 51, 16, 16).build();
        TextOnlyButton blueSubButton = TextOnlyButton.textOnlyBuilder((Component)Component.m_237113_((String)""), btn -> this.blueField.m_94144_(String.valueOf(Math.max(0, Math.min(this.parseColor(this.blueField.m_94155_()) - 1, 255))))).bounds(this.f_97735_ + 34, this.f_97736_ + 72, 16, 16).build();
        TextOnlyButton redPlusButton = TextOnlyButton.textOnlyBuilder((Component)Component.m_237113_((String)""), btn -> this.redField.m_94144_(String.valueOf(Math.max(0, Math.min(this.parseColor(this.redField.m_94155_()) + 1, 255))))).bounds(this.f_97735_ + 102, this.f_97736_ + 30, 16, 16).build();
        TextOnlyButton greenPlusButton = TextOnlyButton.textOnlyBuilder((Component)Component.m_237113_((String)""), btn -> this.greenField.m_94144_(String.valueOf(Math.max(0, Math.min(this.parseColor(this.greenField.m_94155_()) + 1, 255))))).bounds(this.f_97735_ + 102, this.f_97736_ + 51, 16, 16).build();
        TextOnlyButton bluePlusButton = TextOnlyButton.textOnlyBuilder((Component)Component.m_237113_((String)""), btn -> this.blueField.m_94144_(String.valueOf(Math.max(0, Math.min(this.parseColor(this.blueField.m_94155_()) + 1, 255))))).bounds(this.f_97735_ + 102, this.f_97736_ + 72, 16, 16).build();
        TextOnlyButton applyButton = TextOnlyButton.textOnlyBuilder((Component)Component.m_237115_((String)"gui.tponr.apply"), btn -> {
            int r = this.parseColor(this.redField.m_94155_());
            int g = this.parseColor(this.greenField.m_94155_());
            int b = this.parseColor(this.blueField.m_94155_());
            ModMessages.sendToServer(new DyerChangeColorS2CPacket(ColorUtils.rgbToHex(r, g, b), ((SuitDyerMenu)this.f_97732_).getBlockPos()));
        }).scale(0.8f).yOffset(1).color(0).bounds(this.f_97735_ + 33, this.f_97736_ + 120, 86, 9).build();
        this.m_142416_((GuiEventListener)redSubButton);
        this.m_142416_((GuiEventListener)greenSubButton);
        this.m_142416_((GuiEventListener)blueSubButton);
        this.m_142416_((GuiEventListener)redPlusButton);
        this.m_142416_((GuiEventListener)greenPlusButton);
        this.m_142416_((GuiEventListener)bluePlusButton);
        this.m_142416_((GuiEventListener)applyButton);
    }

    private EditBox createColorField(int x, int y) {
        CenteredEditBox box = new CenteredEditBox(this.f_96547_, x, y, 42, 16, (Component)Component.m_237113_((String)"0"));
        box.m_94199_(3);
        box.m_94153_(s -> s.matches("\\d{0,3}"));
        box.m_94182_(false);
        return box;
    }

    private int parseColor(String text) {
        try {
            int val = Integer.parseInt(text);
            return Math.max(0, Math.min(255, val));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        ItemStack previewStack = new ItemStack((ItemLike)ModItems.FAKE_SUIT.get());
        Item item = previewStack.m_41720_();
        if (item instanceof FakeSuitItem) {
            FakeSuitItem dyeable = (FakeSuitItem)item;
            int r = this.parseColor(this.redField.m_94155_());
            int g = this.parseColor(this.greenField.m_94155_());
            int b = this.parseColor(this.blueField.m_94155_());
            dyeable.m_41115_(previewStack, ColorUtils.rgbToHex(r, g, b));
        }
        ItemStack storedItem = ItemStack.f_41583_;
        BlockEntity g = ((SuitDyerMenu)this.f_97732_).getLevel().m_7702_(((SuitDyerMenu)this.f_97732_).getBlockPos());
        if (g instanceof SuitDyerBlockEntity) {
            SuitDyerBlockEntity blockEntity = (SuitDyerBlockEntity)g;
            storedItem = blockEntity.getStoredItem();
        }
        if (!storedItem.m_41619_()) {
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)(this.f_97735_ + 217), (float)(this.f_97736_ + 126), 100.0f);
            pose.m_85841_(45.0f, 45.0f, 45.0f);
            float time = (float)(System.currentTimeMillis() % 18000L) / 50.0f;
            pose.m_252781_(Axis.f_252436_.m_252977_(time));
            pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            Minecraft.m_91087_().m_91291_().m_269128_(previewStack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.f_118083_, pose, (MultiBufferSource)guiGraphics.m_280091_(), null, 0);
            pose.m_85849_();
        }
    }

    protected void m_280003_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }
}

