/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.client.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.studio4sv.tponr.client.ClientAttributesData;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.C2S.UpgradeStatsC2SPacket;
import org.studio4sv.tponr.util.TextOnlyButton;

public class UpgradeScreen
extends Screen {
    private final Map<String, Integer> addedPoints = new HashMap<String, Integer>();
    private Map<String, Integer> currentStats = new HashMap<String, Integer>();
    private int upgradeScreenWidth;
    private int upgradeScreenHeight;
    private int screenWidthStart;
    private int screenHeightStart;
    private int currentExp;
    private int currentExpEdited;
    private int unAppliedLevels;
    private int newHp;
    private int newStamina;

    private int calculateStamina() {
        return 300 + this.currentStats.get("Stamina") * 8;
    }

    private int calculateLevel() {
        AtomicInteger level = new AtomicInteger(1);
        this.currentStats.forEach((key, value) -> {
            if (value > 10) {
                level.addAndGet(value - 10);
            }
        });
        return level.get();
    }

    private int getNeededXP() {
        return 804 + (this.calculateLevel() - 1 + this.unAppliedLevels) * 3;
    }

    public UpgradeScreen() {
        super((Component)Component.m_237115_((String)"gui.tponr.upgrade_screen"));
    }

    private void addPointTo(String stat) {
        if (this.currentExpEdited > this.getNeededXP()) {
            this.currentExpEdited -= this.getNeededXP();
            this.addedPoints.put(stat, this.addedPoints.get(stat) + 1);
            ++this.unAppliedLevels;
        }
    }

    private void removePointFrom(String stat) {
        if (this.addedPoints.get(stat) > 0) {
            this.addedPoints.put(stat, this.addedPoints.get(stat) - 1);
            this.currentExpEdited += this.getNeededXP();
            --this.unAppliedLevels;
        }
    }

    protected void m_7856_() {
        this.upgradeScreenWidth = 286;
        this.upgradeScreenHeight = 168;
        this.screenWidthStart = this.f_96543_ / 2 - this.upgradeScreenWidth / 2;
        this.screenHeightStart = this.f_96544_ / 2 - this.upgradeScreenHeight / 2;
        assert (this.getMinecraft().f_91074_ != null);
        this.currentStats = ClientAttributesData.get();
        this.newHp = (int)this.getMinecraft().f_91074_.m_21233_();
        this.newStamina = this.calculateStamina();
        this.currentExpEdited = this.currentExp = this.getMinecraft().f_91074_.f_36079_;
        this.addedPoints.put("Health", 0);
        this.addedPoints.put("Stamina", 0);
        this.addedPoints.put("Strength", 0);
        this.addedPoints.put("Agility", 0);
        this.addedPoints.put("Intelligence", 0);
        this.addedPoints.put("Luck", 0);
        float buttonScale = 0.7f;
        int n = this.f_96547_.m_92895_(">");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 265, this.screenHeightStart + 39, n, 9, (Component)Component.m_237113_((String)">"), button -> {
            this.addPointTo("Health");
            this.newHp = (int)this.getMinecraft().f_91074_.m_21233_() + this.addedPoints.get("Health") * 2;
        }, buttonScale, 1178727));
        int n2 = this.f_96547_.m_92895_("<");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 240, this.screenHeightStart + 39, n2, 9, (Component)Component.m_237113_((String)"<"), button -> {
            this.removePointFrom("Health");
            this.newHp = (int)this.getMinecraft().f_91074_.m_21233_() + this.addedPoints.get("Health") * 2;
        }, buttonScale, 1178727));
        int n3 = this.f_96547_.m_92895_(">");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 265, this.screenHeightStart + 51, n3, 9, (Component)Component.m_237113_((String)">"), button -> {
            this.addPointTo("Stamina");
            this.newStamina = this.calculateStamina() + this.addedPoints.get("Stamina") * 8;
        }, buttonScale, 1178727));
        int n4 = this.f_96547_.m_92895_("<");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 240, this.screenHeightStart + 51, n4, 9, (Component)Component.m_237113_((String)"<"), button -> {
            this.removePointFrom("Stamina");
            this.newStamina = this.calculateStamina() + this.addedPoints.get("Stamina") * 8;
        }, buttonScale, 1178727));
        int n5 = this.f_96547_.m_92895_(">");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 265, this.screenHeightStart + 63, n5, 9, (Component)Component.m_237113_((String)">"), button -> this.addPointTo("Strength"), buttonScale, 1178727));
        int n6 = this.f_96547_.m_92895_("<");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 240, this.screenHeightStart + 63, n6, 9, (Component)Component.m_237113_((String)"<"), button -> this.removePointFrom("Strength"), buttonScale, 1178727));
        int n7 = this.f_96547_.m_92895_(">");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 265, this.screenHeightStart + 75, n7, 9, (Component)Component.m_237113_((String)">"), button -> this.addPointTo("Agility"), buttonScale, 1178727));
        int n8 = this.f_96547_.m_92895_("<");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 240, this.screenHeightStart + 75, n8, 9, (Component)Component.m_237113_((String)"<"), button -> this.removePointFrom("Agility"), buttonScale, 1178727));
        int n9 = this.f_96547_.m_92895_(">");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 265, this.screenHeightStart + 87, n9, 9, (Component)Component.m_237113_((String)">"), button -> this.addPointTo("Intelligence"), buttonScale, 1178727));
        int n10 = this.f_96547_.m_92895_("<");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 240, this.screenHeightStart + 87, n10, 9, (Component)Component.m_237113_((String)"<"), button -> this.removePointFrom("Intelligence"), buttonScale, 1178727));
        int n11 = this.f_96547_.m_92895_(">");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 265, this.screenHeightStart + 99, n11, 9, (Component)Component.m_237113_((String)">"), button -> this.addPointTo("Luck"), buttonScale, 1178727));
        int n12 = this.f_96547_.m_92895_("<");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 240, this.screenHeightStart + 99, n12, 9, (Component)Component.m_237113_((String)"<"), button -> this.removePointFrom("Luck"), buttonScale, 1178727));
        this.m_142416_((GuiEventListener)new TextOnlyButton(this.screenWidthStart + 146, this.screenHeightStart + 116, 131, 10, (Component)Component.m_237115_((String)"gui.tponr.level_up"), button -> {
            if (this.currentExp < this.getNeededXP()) {
                return;
            }
            ModMessages.sendToServer(new UpgradeStatsC2SPacket(this.addedPoints, this.currentExp - this.currentExpEdited));
            for (Map.Entry<String, Integer> entry : this.currentStats.entrySet()) {
                String key = entry.getKey();
                Integer v = entry.getValue();
                this.currentStats.put(key, v + this.addedPoints.get(key));
            }
            this.currentExp = this.currentExpEdited;
            this.newStamina = this.calculateStamina();
            this.addedPoints.forEach((stat, value) -> this.addedPoints.put((String)stat, 0));
        }, 0.8f, 724494, 1));
        super.m_7856_();
    }

    private void renderScaledText(GuiGraphics pGuiGraphics, String text, int x, int y, int color, float scale, int mouseX, int mouseY, String tooltipKey) {
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        pGuiGraphics.m_280056_(this.f_96547_, text, (int)((float)x / scale), (int)((float)y / scale), color, false);
        pGuiGraphics.m_280168_().m_85849_();
        if (tooltipKey != null) {
            int width = this.f_96547_.m_92895_(text);
            Objects.requireNonNull(this.f_96547_);
            int height = 9;
            if (mouseX >= x && (float)mouseX <= (float)x + (float)width * scale && mouseY >= y && (float)mouseY <= (float)y + (float)height * scale) {
                pGuiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)tooltipKey), mouseX, mouseY);
            }
        }
    }

    private void renderStatText(GuiGraphics pGuiGraphics, String stat, int x, int y) {
        if (this.addedPoints.get(stat) > 0) {
            pGuiGraphics.m_280056_(this.f_96547_, String.valueOf(this.currentStats.get(stat) + this.addedPoints.get(stat)), x - this.f_96547_.m_92895_(String.valueOf(this.currentStats.get(stat) + this.addedPoints.get(stat))) / 2, y, 2531394, false);
        } else {
            pGuiGraphics.m_280056_(this.f_96547_, String.valueOf(this.currentStats.get(stat)), x - this.f_96547_.m_92895_(String.valueOf(this.currentStats.get(stat))) / 2, y, 0xF6F6F6, false);
        }
    }

    private String getTranslation(String key) {
        return Component.m_237115_((String)key).getString();
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        pGuiGraphics.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"tponr", (String)"textures/gui/upgrade_screen.png"), this.f_96543_ / 2 - this.upgradeScreenWidth / 2, this.f_96544_ / 2 - this.upgradeScreenHeight / 2, 0.0f, 0.0f, this.upgradeScreenWidth, this.upgradeScreenHeight, this.upgradeScreenWidth, this.upgradeScreenHeight);
        pGuiGraphics.m_280056_(this.f_96547_, this.getTranslation("gui.tponr.level") + " " + this.calculateLevel(), this.screenWidthStart + 36, this.screenHeightStart + 21, 1178727, false);
        this.renderScaledText(pGuiGraphics, "EXP: " + this.getNeededXP() + " / " + this.currentExpEdited, this.screenWidthStart + 26, this.screenHeightStart + 41, 2434854, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, this.getTranslation("gui.tponr.stats"), this.screenWidthStart + 36, this.screenHeightStart + 62, 1178727, 1.0f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, this.getTranslation("gui.tponr.health_capacity"), this.screenWidthStart + 38, this.screenHeightStart + 91, 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, this.getTranslation("gui.tponr.stamina_capacity"), this.screenWidthStart + 38, this.screenHeightStart + 104, 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, "\u00a7k" + this.getTranslation("gui.tponr.mana_capacity"), this.screenWidthStart + 38, this.screenHeightStart + 118, 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, String.valueOf((int)player.m_21233_()), this.screenWidthStart + 114 - this.f_96547_.m_92895_(String.valueOf((int)player.m_21233_())), this.screenHeightStart + 91, 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, String.valueOf(this.calculateStamina()), this.screenWidthStart + 114 - this.f_96547_.m_92895_(String.valueOf(this.calculateStamina())), this.screenHeightStart + 105, 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, "???", this.screenWidthStart + 114 - this.f_96547_.m_92895_("???"), this.screenHeightStart + 117, 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, String.valueOf(this.newHp), this.screenWidthStart + 118, this.screenHeightStart + 91, (float)this.newHp != player.m_21233_() ? 2531394 : 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, String.valueOf(this.newStamina), this.screenWidthStart + 118, this.screenHeightStart + 105, this.newStamina != this.calculateStamina() ? 2531394 : 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, "???", this.screenWidthStart + 118, this.screenHeightStart + 117, 0xF6F6F6, 0.9f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, this.getTranslation("gui.tponr.attributes"), this.screenWidthStart + 172, this.screenHeightStart + 20, 1178727, 1.0f, pMouseX, pMouseY, null);
        this.renderScaledText(pGuiGraphics, this.getTranslation("stat.tponr.health"), this.screenWidthStart + 166, this.screenHeightStart + 39, 0xF6F6F6, 0.9f, pMouseX, pMouseY, "tooltip.tponr.health");
        this.renderScaledText(pGuiGraphics, this.getTranslation("stat.tponr.stamina"), this.screenWidthStart + 166, this.screenHeightStart + 52, 0xF6F6F6, 0.9f, pMouseX, pMouseY, "tooltip.tponr.stamina");
        this.renderScaledText(pGuiGraphics, this.getTranslation("stat.tponr.strength"), this.screenWidthStart + 166, this.screenHeightStart + 64, 0xF6F6F6, 0.9f, pMouseX, pMouseY, "tooltip.tponr.strength");
        this.renderScaledText(pGuiGraphics, this.getTranslation("stat.tponr.agility"), this.screenWidthStart + 166, this.screenHeightStart + 76, 0xF6F6F6, 0.9f, pMouseX, pMouseY, "tooltip.tponr.agility");
        this.renderScaledText(pGuiGraphics, this.getTranslation("stat.tponr.intelligence"), this.screenWidthStart + 166, this.screenHeightStart + 88, 0xF6F6F6, 0.9f, pMouseX, pMouseY, "tooltip.tponr.intelligence");
        this.renderScaledText(pGuiGraphics, this.getTranslation("stat.tponr.luck"), this.screenWidthStart + 166, this.screenHeightStart + 100, 0xF6F6F6, 0.9f, pMouseX, pMouseY, "tooltip.tponr.luck");
        this.renderStatText(pGuiGraphics, "Health", this.screenWidthStart + 255, this.screenHeightStart + 39);
        this.renderStatText(pGuiGraphics, "Stamina", this.screenWidthStart + 255, this.screenHeightStart + 52);
        this.renderStatText(pGuiGraphics, "Strength", this.screenWidthStart + 255, this.screenHeightStart + 64);
        this.renderStatText(pGuiGraphics, "Agility", this.screenWidthStart + 255, this.screenHeightStart + 76);
        this.renderStatText(pGuiGraphics, "Intelligence", this.screenWidthStart + 255, this.screenHeightStart + 88);
        this.renderStatText(pGuiGraphics, "Luck", this.screenWidthStart + 255, this.screenHeightStart + 100);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_7043_() {
        return false;
    }
}

