/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.studio4sv.tponr.TPONR;

public class HungerHud {
    private static final ResourceLocation HUNGER_TEXTURE = TPONR.id("textures/gui/hunger.png");
    private static int currentHungerStage;
    private static boolean enabled;
    public static final IGuiOverlay HUD_HUNGER;

    public static void toggle() {
        enabled = !enabled;
    }

    public static void setHungerStage(int stage) {
        currentHungerStage = Math.max(1, Math.min(6, stage));
    }

    static {
        enabled = true;
        HUD_HUNGER = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
            if (!enabled) {
                return;
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HUNGER_TEXTURE);
            int padding = 5;
            int scaledSize = 40;
            int textureSize = 26;
            int x = screenWidth - scaledSize - padding;
            int y = scaledSize + padding * 4;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            float scale = 1.3461539f;
            poseStack.m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280163_(HUNGER_TEXTURE, 0, 0, 0.0f, (float)(textureSize * (currentHungerStage - 1)), textureSize, textureSize, textureSize, textureSize * 6);
            poseStack.m_85849_();
        };
    }
}

