/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.studio4sv.tponr.TPONR;
import org.studio4sv.tponr.client.ClientStaminaData;

public class StaminaHud {
    private static float staminaAmount;
    private static boolean enabled;
    private static final ResourceLocation STAMINA_TEXTURE;
    public static final IGuiOverlay HUD_STAMINA;

    public static void toggle() {
        enabled = !enabled;
    }

    public static void setStaminaAmount(float stamina) {
        staminaAmount = Math.max(0.0f, Math.min(stamina, (float)ClientStaminaData.getMax()));
    }

    static {
        enabled = true;
        STAMINA_TEXTURE = TPONR.id("textures/gui/stamina.png");
        HUD_STAMINA = (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            int currentTileWidth;
            int i;
            if (!enabled) {
                return;
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)STAMINA_TEXTURE);
            int y = screenHeight - 31;
            int textureWidth = 30;
            int textureHeight = 16;
            int SCALE_FACTOR = 3;
            int maxStaminaPixels = ClientStaminaData.getMax() / 3;
            int currentStaminaPixels = (int)staminaAmount / 3;
            int centerX = screenWidth / 2;
            poseStack.m_280163_(STAMINA_TEXTURE, centerX - maxStaminaPixels / 2 - 2, y, 0.0f, 0.0f, 2, 7, textureWidth, textureHeight);
            poseStack.m_280163_(STAMINA_TEXTURE, centerX + maxStaminaPixels / 2, y, 28.0f, 0.0f, 2, 7, textureWidth, textureHeight);
            for (int i2 = 0; i2 < maxStaminaPixels; i2 += 7) {
                int currentTileWidth2 = Math.min(7, maxStaminaPixels - i2);
                poseStack.m_280163_(STAMINA_TEXTURE, centerX - maxStaminaPixels / 2 + i2, y, 21.0f, 0.0f, currentTileWidth2, 7, textureWidth, textureHeight);
            }
            int halfMaxPixels = maxStaminaPixels / 2;
            float fillPercent = (float)currentStaminaPixels / (float)maxStaminaPixels;
            int sidePixels = Math.round((float)halfMaxPixels * fillPercent);
            for (i = 0; i < sidePixels; i += 7) {
                currentTileWidth = Math.min(7, sidePixels - i);
                poseStack.m_280163_(STAMINA_TEXTURE, centerX - i - currentTileWidth, y, 2.0f, 0.0f, currentTileWidth, 7, textureWidth, textureHeight);
            }
            for (i = 0; i < sidePixels; i += 7) {
                currentTileWidth = Math.min(7, sidePixels - i);
                poseStack.m_280163_(STAMINA_TEXTURE, centerX + i, y, 2.0f, 0.0f, currentTileWidth, 7, textureWidth, textureHeight);
            }
            poseStack.m_280163_(STAMINA_TEXTURE, centerX - 6, y, 9.0f, 0.0f, 12, 8, textureWidth, textureHeight);
        };
    }
}

