/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.studio4sv.tponr.TPONR;
import org.studio4sv.tponr.util.RadiationUtils;

public class SuitOverlayHud {
    private static final ResourceLocation OVERLAY_TEXTURE = TPONR.id("textures/gui/suit_overlay.png");
    private static final ResourceLocation BATTERY_TEXTURE = TPONR.id("textures/gui/battery.png");
    private static final ResourceLocation DANGER_TEXTURE = TPONR.id("textures/gui/danger.png");
    private static boolean enabled = true;
    private static float charge;
    public static final IGuiOverlay HUD_OVERLAY;

    public static void toggle() {
        enabled = !enabled;
    }

    public static void setEnabled(boolean enabled) {
        SuitOverlayHud.enabled = enabled;
    }

    public static void setCharge(float charge) {
        SuitOverlayHud.charge = charge;
    }

    private static void drawOutline(ForgeGui gui, GuiGraphics guiGraphics, int x, int y, String text, int color) {
        guiGraphics.m_280056_(gui.m_93082_(), text, x + 1, y, color, false);
        guiGraphics.m_280056_(gui.m_93082_(), text, x - 1, y, color, false);
        guiGraphics.m_280056_(gui.m_93082_(), text, x, y + 1, color, false);
        guiGraphics.m_280056_(gui.m_93082_(), text, x, y - 1, color, false);
    }

    static {
        HUD_OVERLAY = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
            if (!enabled) {
                return;
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)OVERLAY_TEXTURE);
            RenderSystem.enableBlend();
            int overlayWidth = 910;
            int overlayHeight = 1026;
            float overlayScale = (float)screenHeight / (float)overlayHeight;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(overlayScale, overlayScale, 1.0f);
            guiGraphics.m_280163_(OVERLAY_TEXTURE, 0, 0, 0.0f, 0.0f, overlayWidth / 2, overlayHeight, overlayWidth, overlayHeight);
            guiGraphics.m_280163_(OVERLAY_TEXTURE, (int)((float)screenWidth / overlayScale) - overlayWidth / 2, 0, (float)overlayWidth / 2.0f, 0.0f, overlayWidth / 2, overlayHeight, overlayWidth, overlayHeight);
            guiGraphics.m_280168_().m_85849_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_TEXTURE);
            int widgetX = 45;
            int batteryWidth = 24;
            int batteryHeight = 22;
            int dangerWidth = 23;
            int dangerHeight = 20;
            int batteryY = screenHeight - batteryHeight - 2;
            int dangerY = screenHeight - batteryHeight - 8 - dangerHeight;
            guiGraphics.m_280163_(DANGER_TEXTURE, widgetX - dangerWidth / 4, dangerY, 0.0f, 0.0f, dangerWidth, dangerHeight, dangerWidth, dangerHeight);
            guiGraphics.m_280163_(BATTERY_TEXTURE, widgetX, batteryY, (float)batteryWidth / 2.0f, 0.0f, batteryWidth / 2, batteryHeight, batteryWidth, batteryHeight);
            int filledHeight = Math.round((float)batteryHeight / 100.0f * charge);
            int fillY = batteryY + (batteryHeight - filledHeight);
            guiGraphics.m_280163_(BATTERY_TEXTURE, widgetX, fillY, 0.0f, (float)(batteryHeight - filledHeight), batteryWidth / 2, filledHeight, batteryWidth, batteryHeight);
            String chargeText = String.format("%.2f", Float.valueOf(charge)) + "%";
            SuitOverlayHud.drawOutline(gui, guiGraphics, widgetX + 15, batteryY, chargeText, 0);
            guiGraphics.m_280056_(gui.m_93082_(), chargeText, widgetX + 15, batteryY, 7387388, false);
            int levelY = batteryY - 25;
            String radiationLvlText = Component.m_237115_((String)"gui.tponr.lvl").getString() + " " + RadiationUtils.levelForPlayer((Player)Minecraft.m_91087_().f_91074_);
            SuitOverlayHud.drawOutline(gui, guiGraphics, widgetX + 20, levelY, radiationLvlText, 0);
            guiGraphics.m_280056_(gui.m_93082_(), radiationLvlText, widgetX + 20, levelY, 7387388, false);
            RenderSystem.disableBlend();
        };
    }
}

