/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.studio4sv.tponr.mechanics.stamina.PlayerStamina;
import org.studio4sv.tponr.mechanics.stamina.PlayerStaminaProvider;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.StaminaDataSyncS2CPacket;
import org.studio4sv.tponr.networking.packet.S2C.ToggleWidgetS2CPacket;

public class HUDControllerCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tponr").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"widget").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"toggle").then(Commands.m_82127_((String)"all").executes(context -> {
            ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            if (!executor.m_20148_().equals(target.m_20148_()) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.tponr.forbidden")).create();
            }
            ModMessages.sendToPlayer(new ToggleWidgetS2CPacket("all"), target);
            return 1;
        }))).then(Commands.m_82127_((String)"hunger").executes(context -> {
            ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            if (!executor.m_20148_().equals(target.m_20148_()) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.tponr.forbidden")).create();
            }
            ModMessages.sendToPlayer(new ToggleWidgetS2CPacket("hunger"), target);
            return 1;
        }))).then(Commands.m_82127_((String)"stamina").executes(context -> {
            ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            if (!executor.m_20148_().equals(target.m_20148_()) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.tponr.forbidden")).create();
            }
            ModMessages.sendToPlayer(new ToggleWidgetS2CPacket("stamina"), target);
            return 1;
        }))).then(Commands.m_82127_((String)"points").executes(context -> {
            ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            if (!executor.m_20148_().equals(target.m_20148_()) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.tponr.forbidden")).create();
            }
            ModMessages.sendToPlayer(new ToggleWidgetS2CPacket("points"), target);
            return 1;
        }))))).then(Commands.m_82127_((String)"mechanic").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"stamina").then(Commands.m_82127_((String)"setMax").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)PlayerStamina.getLimit())).executes(context -> {
            ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            int value = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            if (!executor.m_20148_().equals(target.m_20148_()) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.tponr.forbidden")).create();
            }
            target.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                stamina.setMaxStamina(value);
                ModMessages.sendToPlayer(new StaminaDataSyncS2CPacket(stamina.getStamina(), value), target);
            });
            return 1;
        })))).then(Commands.m_82127_((String)"toggle").executes(context -> {
            ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            if (!executor.m_20148_().equals(target.m_20148_()) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.tponr.forbidden")).create();
            }
            target.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(PlayerStamina::toggleStamina);
            return 1;
        }))))).then(Commands.m_82127_((String)"attribute").then(Commands.m_82129_((String)"attributes", (ArgumentType)StringArgumentType.string()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer executor = ((CommandSourceStack)context.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)context, (String)"player");
            String attributeName = StringArgumentType.getString((CommandContext)context, (String)"attributes");
            String value = StringArgumentType.getString((CommandContext)context, (String)"value");
            if (!executor.m_20148_().equals(target.m_20148_()) && !((CommandSourceStack)context.getSource()).m_6761_(2)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.tponr.forbidden")).create();
            }
            return 1;
        })))))));
    }
}

