/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.items;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.studio4sv.tponr.registers.ModItems;

public class HazmatSuitPackItem
extends Item
implements DyeableLeatherItem {
    public HazmatSuitPackItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_41113_(@NotNull ItemStack stack) {
        return super.m_41113_(stack);
    }

    public int m_41121_(@NotNull ItemStack stack) {
        return super.m_41113_(stack) ? super.m_41121_(stack) : 0xFFFFFF;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            boolean emptyArmor = true;
            for (ItemStack armor : pPlayer.m_6168_()) {
                if (armor.m_41619_()) continue;
                emptyArmor = false;
                break;
            }
            if (!emptyArmor) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            CompoundTag tag = stack.m_41784_();
            int color = this.m_41121_(stack);
            float charge = tag.m_128441_("charge") ? tag.m_128457_("charge") : 0.0f;
            pPlayer.m_8061_(EquipmentSlot.HEAD, this.createPiece((Item)ModItems.HAZMAT_SUIT_HELMET.get(), color, charge));
            pPlayer.m_8061_(EquipmentSlot.CHEST, this.createPiece((Item)ModItems.HAZMAT_SUIT_CHESTPLATE.get(), color, charge));
            pPlayer.m_8061_(EquipmentSlot.LEGS, this.createPiece((Item)ModItems.HAZMAT_SUIT_LEGGINGS.get(), color, charge));
            pPlayer.m_8061_(EquipmentSlot.FEET, this.createPiece((Item)ModItems.HAZMAT_SUIT_BOOTS.get(), color, charge));
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.m_5776_());
    }

    private ItemStack createPiece(Item item, int color, float charge) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.m_41784_().m_128350_("charge", charge);
        DyeableLeatherItem dyeable = (DyeableLeatherItem)item;
        dyeable.m_41115_(stack, color);
        return stack;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.tponr.hazmat_suit_pack.desc"));
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.tponr.hazmat_suit.desc").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)((float)Math.round(pStack.m_41784_().m_128457_("charge") * 100.0f) / 100.0f + "%"))));
    }
}

