/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.mechanics.attributes;

import java.util.UUID;
import kirderf1.inventoryfree.PlayerData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.studio4sv.tponr.mechanics.attributes.PlayerAttributesProvider;
import org.studio4sv.tponr.mechanics.stamina.PlayerStaminaProvider;
import org.studio4sv.tponr.networking.ModMessages;
import org.studio4sv.tponr.networking.packet.S2C.AttributesDataSyncS2CPacket;

@Mod.EventBusSubscriber(modid="tponr")
public class AttributesHandler {
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440000");
    private static final UUID STRENGTH_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440001");
    private static final UUID AGILITY_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440002");
    private static final UUID LUCK_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440003");

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AttributesHandler.applyAttributeModifiers(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AttributesHandler.applyAttributeModifiers(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AttributesHandler.applyAttributeModifiers(serverPlayer);
        }
    }

    public static void applyAttributeModifiers(ServerPlayer player) {
        player.getCapability(PlayerAttributesProvider.PLAYER_ATTRIBUTES).ifPresent(attributes -> {
            int healthValue = attributes.get("Health");
            double healthBonus = (double)(healthValue - 10) * 2.0;
            AttributesHandler.applyAttributeModifier((Player)player, Attributes.f_22276_, HEALTH_MODIFIER_UUID, "Health Attribute Bonus", healthBonus, AttributeModifier.Operation.ADDITION);
            int strengthValue = attributes.get("Strength");
            double strengthBonus = (double)(strengthValue - 10) * 0.5;
            AttributesHandler.applyAttributeModifier((Player)player, Attributes.f_22281_, STRENGTH_MODIFIER_UUID, "Strength Attribute Bonus", strengthBonus, AttributeModifier.Operation.ADDITION);
            PlayerData.setUnlockedSlots((ServerPlayer)player, (int)(strengthValue - 10));
            int agilityValue = attributes.get("Agility");
            double agilityBonus = (double)(agilityValue - 10) * 0.01;
            AttributesHandler.applyAttributeModifier((Player)player, Attributes.f_22279_, AGILITY_MODIFIER_UUID, "Agility Attribute Bonus", agilityBonus, AttributeModifier.Operation.MULTIPLY_BASE);
            int staminaValue = attributes.get("Stamina");
            int staminaBonus = (staminaValue - 10) * 8;
            player.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
                int newMaxStamina = 150 + staminaBonus;
                stamina.setMaxStamina(newMaxStamina);
            });
            int luckValue = attributes.get("Stamina");
            int luckBonus = luckValue - 10;
            AttributesHandler.applyAttributeModifier((Player)player, Attributes.f_22286_, LUCK_MODIFIER_UUID, "Luck Attribute Bonus", luckBonus, AttributeModifier.Operation.MULTIPLY_BASE);
        });
    }

    private static void applyAttributeModifier(Player player, Attribute attribute, UUID uuid, String name, double amount, AttributeModifier.Operation operation) {
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(uuid);
            if (amount != 0.0) {
                AttributeModifier modifier = new AttributeModifier(uuid, name, amount, operation);
                attributeInstance.m_22125_(modifier);
            }
        }
    }

    public static void updatePlayerAttributes(ServerPlayer player) {
        AttributesHandler.applyAttributeModifiers(player);
        player.getCapability(PlayerAttributesProvider.PLAYER_ATTRIBUTES).ifPresent(attributes -> ModMessages.sendToPlayer(new AttributesDataSyncS2CPacket(attributes.getAttributes()), player));
    }
}

