/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.mechanics.attributes;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.studio4sv.tponr.client.ClientAttributesData;
import org.studio4sv.tponr.mechanics.attributes.PlayerAttributesProvider;

@Mod.EventBusSubscriber(modid="tponr")
public class IntelligenceHandler {
    private static final Map<Integer, Integer> TIER_REQUIREMENTS = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> AGILITY_REQUIREMENTS = new HashMap<Integer, Integer>();
    static int[] agilityRequirement = new int[1];

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        IntelligenceHandler.checkToolUsage((PlayerInteractEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onItemUseBlock(PlayerInteractEvent.RightClickBlock event) {
        IntelligenceHandler.checkToolUsage((PlayerInteractEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onItemLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        IntelligenceHandler.checkToolUsage((PlayerInteractEvent)event);
    }

    public static int calculate(ItemStack itemStack) {
        int requiredIntelligence;
        Item item = itemStack.m_41720_();
        if (itemStack.m_41619_()) {
            return 0;
        }
        int enchantmentBonus = 0;
        if (!itemStack.m_41785_().isEmpty()) {
            enchantmentBonus = EnchantmentHelper.m_44831_((ItemStack)itemStack).size() * 2;
        }
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            int tier = tieredItem.m_43314_().m_6604_();
            int baseRequirement = TIER_REQUIREMENTS.getOrDefault(tier, 25);
            IntelligenceHandler.agilityRequirement[0] = AGILITY_REQUIREMENTS.getOrDefault(tier, 15);
            int additionalRequirement = 0;
            if (item instanceof SwordItem) {
                double attackDamage = 0.0;
                double attackSpeed = 0.0;
                Collection damageModifiers = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_);
                for (AttributeModifier modifier : damageModifiers) {
                    attackDamage += modifier.m_22218_();
                }
                Collection speedModifiers = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_);
                for (AttributeModifier modifier : speedModifiers) {
                    attackSpeed += modifier.m_22218_();
                }
                additionalRequirement = (int)Math.ceil(attackDamage * 0.5 + attackSpeed * 0.75);
            } else if (item instanceof AxeItem) {
                double attackDamage = 0.0;
                Collection damageModifiers = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_);
                for (AttributeModifier modifier : damageModifiers) {
                    attackDamage += modifier.m_22218_();
                }
                additionalRequirement = (int)Math.ceil(attackDamage * 0.75);
            } else {
                additionalRequirement = item instanceof PickaxeItem ? 5 : (item instanceof ShovelItem ? 3 : (item instanceof HoeItem ? 2 : 1));
            }
            requiredIntelligence = baseRequirement + additionalRequirement + enchantmentBonus;
        } else if (item instanceof BowItem) {
            requiredIntelligence = 15 + enchantmentBonus;
        } else if (item instanceof CrossbowItem) {
            requiredIntelligence = 20 + enchantmentBonus;
        } else {
            return 0;
        }
        return requiredIntelligence;
    }

    private static void checkToolUsage(PlayerInteractEvent event) {
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_41619_()) {
            return;
        }
        int requiredIntelligence = IntelligenceHandler.calculate(itemStack);
        if (requiredIntelligence <= 0) {
            return;
        }
        if (player instanceof LocalPlayer) {
            return;
        }
        player.getCapability(PlayerAttributesProvider.PLAYER_ATTRIBUTES).ifPresent(attributes -> {
            int intelligence = attributes.get("Intelligence");
            if (intelligence < requiredIntelligence) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        List tooltip = event.getToolTip();
        int requiredIntelligence = IntelligenceHandler.calculate(itemStack);
        if (requiredIntelligence > 0 && player != null) {
            int[] playerIntelligence = new int[]{0};
            int[] playerAgility = new int[]{0};
            playerIntelligence[0] = ClientAttributesData.getValue("Intelligence");
            playerAgility[0] = ClientAttributesData.getValue("Agility");
            tooltip.add(Component.m_237115_((String)"tooltip.tponr.required_stats").m_130940_(ChatFormatting.BLUE));
            MutableComponent intelligenceStat = Component.m_237115_((String)"stat.tponr.intelligence").m_7220_((Component)Component.m_237113_((String)": ")).m_130940_(ChatFormatting.WHITE);
            ChatFormatting intelligenceColor = playerIntelligence[0] >= requiredIntelligence ? ChatFormatting.GREEN : ChatFormatting.RED;
            MutableComponent intelligenceValueText = Component.m_237113_((String)String.valueOf(requiredIntelligence)).m_130940_(intelligenceColor);
            MutableComponent agilityStat = Component.m_237115_((String)"stat.tponr.agility").m_7220_((Component)Component.m_237113_((String)": ")).m_130940_(ChatFormatting.WHITE);
            ChatFormatting agilityColor = playerAgility[0] >= agilityRequirement[0] ? ChatFormatting.GREEN : ChatFormatting.RED;
            MutableComponent agilityValueText = Component.m_237113_((String)String.valueOf(agilityRequirement[0])).m_130940_(agilityColor);
            tooltip.add(Component.m_237119_().m_7220_((Component)intelligenceStat).m_7220_((Component)intelligenceValueText));
            tooltip.add(Component.m_237119_().m_7220_((Component)agilityStat).m_7220_((Component)agilityValueText));
        }
    }

    static {
        TIER_REQUIREMENTS.put(0, 5);
        TIER_REQUIREMENTS.put(1, 10);
        TIER_REQUIREMENTS.put(2, 15);
        TIER_REQUIREMENTS.put(3, 25);
        TIER_REQUIREMENTS.put(4, 35);
        AGILITY_REQUIREMENTS.put(0, 5);
        AGILITY_REQUIREMENTS.put(1, 10);
        AGILITY_REQUIREMENTS.put(2, 15);
        AGILITY_REQUIREMENTS.put(3, 25);
        AGILITY_REQUIREMENTS.put(4, 35);
    }
}

