/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.mechanics.attributes;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;

public class PlayerAttributes {
    private final Map<String, Integer> attributes = new HashMap<String, Integer>();

    public PlayerAttributes() {
        this.attributes.put("Health", 10);
        this.attributes.put("Stamina", 10);
        this.attributes.put("Strength", 10);
        this.attributes.put("Agility", 10);
        this.attributes.put("Intelligence", 10);
        this.attributes.put("Luck", 10);
    }

    public Map<String, Integer> getAttributes() {
        return this.attributes;
    }

    public int get(String key) {
        return this.attributes.getOrDefault(key, 10);
    }

    public void set(String key, int value) {
        this.attributes.put(key, value);
    }

    public void copyFrom(PlayerAttributes source) {
        for (String key : this.attributes.keySet()) {
            this.set(key, source.get(key));
        }
    }

    public void saveNBTData(CompoundTag nbt) {
        for (String key : this.attributes.keySet()) {
            nbt.m_128405_(key, this.attributes.get(key).intValue());
        }
    }

    public void loadNBTData(CompoundTag nbt) {
        for (String key : this.attributes.keySet()) {
            if (nbt.m_128441_(key)) {
                this.attributes.put(key, nbt.m_128451_(key));
                continue;
            }
            this.attributes.put(key, 10);
        }
    }
}

