/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.mechanics.stamina;

import net.minecraft.nbt.CompoundTag;

public class PlayerStamina {
    private float stamina = 300.0f;
    private int maxStamina = 300;
    private boolean staminaEnabled = true;
    private static final int limit = 1000;

    public static int getLimit() {
        return 1000;
    }

    public void copyFrom(PlayerStamina source) {
        this.stamina = source.stamina;
    }

    public void toggleStamina() {
        this.staminaEnabled = !this.staminaEnabled;
    }

    public boolean isEnabled() {
        return this.staminaEnabled;
    }

    public float getStamina() {
        return this.stamina;
    }

    public int getMaxStamina() {
        return this.maxStamina;
    }

    public void setMaxStamina(int maxStamina) {
        this.maxStamina = Math.min(maxStamina, 1000);
        if (this.stamina > (float)this.maxStamina) {
            this.stamina = this.maxStamina;
        }
    }

    public void addStamina(int amount) {
        if (this.staminaEnabled) {
            this.stamina = Math.min(this.stamina + (float)amount, (float)this.maxStamina);
        }
    }

    public void subStamina(float amount) {
        if (this.staminaEnabled) {
            this.stamina = Math.max(this.stamina - amount, 0.0f);
        }
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128350_("stamina", this.stamina);
        nbt.m_128405_("maxStamina", this.maxStamina);
        nbt.m_128379_("staminaEnabled", this.staminaEnabled);
    }

    public void loadNBTData(CompoundTag nbt) {
        this.stamina = nbt.m_128451_("stamina");
        this.maxStamina = nbt.m_128451_("maxStamina");
        this.staminaEnabled = nbt.m_128471_("staminaEnabled");
    }
}

