/*
 * Decompiled with CFR 0.152.
 */
package org.studio4sv.tponr.mechanics.stamina;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.studio4sv.tponr.mechanics.stamina.PlayerStaminaProvider;

@Mod.EventBusSubscriber(modid="tponr")
public class StaminaAttributeHandler {
    private static final UUID STAMINA_SPEED_MODIFIER_ID = UUID.fromString("7107DE5E-7CE8-4030-940E-514C1F160890");
    private static final Map<UUID, Boolean> lowStaminaState = new HashMap<UUID, Boolean>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.player;
        UUID playerId = serverPlayer.m_20148_();
        serverPlayer.getCapability(PlayerStaminaProvider.PLAYER_STAMINA).ifPresent(stamina -> {
            boolean hasLowStamina = stamina.getStamina() < 0.3f;
            boolean wasLowStamina = lowStaminaState.getOrDefault(playerId, false);
            lowStaminaState.put(playerId, hasLowStamina);
            if (hasLowStamina && serverPlayer.m_20142_()) {
                serverPlayer.m_6858_(false);
                StaminaAttributeHandler.applySpeedModifier(serverPlayer, -0.5);
            } else if (!hasLowStamina && wasLowStamina) {
                StaminaAttributeHandler.removeSpeedModifier(serverPlayer);
            }
            if (serverPlayer.m_20142_() && !hasLowStamina && !serverPlayer.m_7500_() && !serverPlayer.m_5833_()) {
                stamina.subStamina(0.3f);
            }
        });
    }

    private static void applySpeedModifier(ServerPlayer player, double modifier) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute != null) {
            attribute.m_22120_(STAMINA_SPEED_MODIFIER_ID);
            attribute.m_22125_(new AttributeModifier(STAMINA_SPEED_MODIFIER_ID, "stamina_speed_penalty", modifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private static void removeSpeedModifier(ServerPlayer player) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22279_);
        if (attribute != null) {
            attribute.m_22120_(STAMINA_SPEED_MODIFIER_ID);
        }
    }
}

